<?php
/**
 * Woocommerce Store's Common functionalities will be written here
 *
 * PHP version 5.6
 *
 * @category  Woo-Commerce
 * @package   Store
 * @author    Tanmaya Patra <tanmayap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace CommonStoreSpace\Controllers;

use App\Components\Controllers\Component as ParentController;
use Automattic\WooCommerce\Client;

/**
 * Asset Type Class
 *
 * @category Woo-Commerce
 * @package  Store
 * @author   Tanmaya Patra <tanmayap@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class StoreController extends ParentController
{
    /**
     * Initialize Constructor
     * 
     * @var string
     */
    public $storePath = '';
    
    /**
     * Initialize Constructor
     */
    public function __construct()
    {
        $apiURL = str_replace('/'.BASE_DIR.'/', '/', API_URL);
        $this->wc = new Client(
            $apiURL,
            API_CK,
            API_CS,
            [
                'wp_api' => true,
                'timeout' => 36000,
                'version' => API_VER,
                //'query_string_auth' => true,
                'verify_ssl' => IS_API_SECURE,
            ]
        );
        $this->plugin = new Client(
            $apiURL,
            API_CK,
            API_CS,
            [
                'wp_api' => true,
                //'timeout' => 36000,
                'version' => 'InkXEProductDesigner',
                // 'verify_ssl' => IS_API_SECURE,
            ]
        );
        $this->storePath = $this->plugin->get('path');
        set_time_limit(0);
    }
}
