## ShipmentConfirmation

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**shipment_identifier** | **string** | Unique shipment ID (not used over the last 365 days). |
**shipment_confirmation_type** | **string** | Indicates if this shipment confirmation is the initial confirmation, or intended to replace an already posted shipment confirmation. If replacing an existing shipment confirmation, be sure to provide the identical shipmentIdentifier and sellingParty information as in the previous confirmation. |
**shipment_type** | **string** | The type of shipment. | [optional]
**shipment_structure** | **string** | Shipment hierarchical structure. | [optional]
**transportation_details** | [**\SellingPartnerApi\Model\VendorShipping\TransportationDetails**](TransportationDetails.md) |  | [optional]
**amazon_reference_number** | **string** | The Amazon Reference Number is a unique identifier generated by Amazon for all Collect/WePay shipments when you submit  a routing request. This field is mandatory for Collect/WePay shipments. | [optional]
**shipment_confirmation_date** | **string** | Date on which the shipment confirmation was submitted. Must be in ISO 8601 format. |
**shipped_date** | **string** | The date and time of the departure of the shipment from the vendor&#39;s location. Vendors are requested to send ASNs within 30 minutes of departure from their warehouse/distribution center or at least 6 hours prior to the appointment time at the Amazon destination warehouse, whichever is sooner. Shipped date mentioned in the shipment confirmation should not be in the future. Must be in ISO 8601 format. | [optional]
**estimated_delivery_date** | **string** | The date and time on which the shipment is expected to reach buyer&#39;s warehouse. It needs to be an estimate based on the average transit time between ship from location and the destination. The exact appointment time will be provided by the buyer and is potentially not known when creating the shipment confirmation. Must be in ISO 8601 format. | [optional]
**selling_party** | [**\SellingPartnerApi\Model\VendorShipping\PartyIdentification**](PartyIdentification.md) |  |
**ship_from_party** | [**\SellingPartnerApi\Model\VendorShipping\PartyIdentification**](PartyIdentification.md) |  |
**ship_to_party** | [**\SellingPartnerApi\Model\VendorShipping\PartyIdentification**](PartyIdentification.md) |  |
**shipment_measurements** | [**\SellingPartnerApi\Model\VendorShipping\ShipmentMeasurements**](ShipmentMeasurements.md) |  | [optional]
**import_details** | [**\SellingPartnerApi\Model\VendorShipping\ImportDetails**](ImportDetails.md) |  | [optional]
**shipped_items** | [**\SellingPartnerApi\Model\VendorShipping\Item[]**](Item.md) | A list of the items in this shipment and their associated details. If any of the item detail fields are common at a carton or a pallet level, provide them at the corresponding carton or pallet level. |
**cartons** | [**\SellingPartnerApi\Model\VendorShipping\Carton[]**](Carton.md) | A list of the cartons in this shipment. | [optional]
**pallets** | [**\SellingPartnerApi\Model\VendorShipping\Pallet[]**](Pallet.md) | A list of the pallets in this shipment. | [optional]

[[VendorShipping Models]](../) [[API list]](../../Api) [[README]](../../../README.md)
