<?php
/**
 * Manage Configurator Pattern
 *
 * PHP version 5.6
 *
 * @category  ConfiguratorPattern
 * @package   Assets
 * @author    Dibya Jyoti <divya@imprintnext.com>
 * @copyright 2024-2025 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

 use App\Middlewares\ValidateJWTToken as ValidateJWT;
 use App\Modules\ConfiguratorPatterns\Controllers\ConfiguratorPatternController as ConfiguratorPattern;



 // Instantiate the Container
$container = $app->getContainer();

// Configurator Pattern Routes List
$app->group(
    '/config-pattern', function () use ($app) {
        $app->get('', ConfiguratorPattern::class . ':getConfigPatternList');
        $app->get('/{id}', ConfiguratorPattern::class . ':getConfigPatternList');
        $app->post('', ConfiguratorPattern::class . ':saveConfigPattern');
        $app->post('/{id}', ConfiguratorPattern::class . ':updateConfigPattern');
        $app->delete('/{id}', ConfiguratorPattern::class . ':deleteConfigPattern');
    }
);

// Categories Routes List
  $app->delete('/categories/config-pattern/{id}',  ConfiguratorPattern::class . ':deleteCategory');