<?php
/**
 * Routes
 *
 * PHP version 5.6
 *
 * @category  Routes
 * @package   SLIM_Routes
 * @author    Satyabrata <satyabratap@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin ProductsController
 */

use App\Middlewares\ValidateJWTToken as ValidateJWT;
use App\Modules\Integration\Controllers\IntegrationController as Integration;
use App\Modules\Integration\Controllers\CatalogSupplierController as CatalogSupplier;
use App\Modules\Integration\Controllers\ZapController;
use App\Modules\Integration\Controllers\AmazonController;

$container = $app->getContainer();


/**
 * Integration Routes List
 */

// End point use for Zapier and Shipstation so JWT not applicable for this end point
$app->get('/integration/shipstation', Integration::class . ':shipstationOrderShipping');
$app->post('/integration/shipstation', Integration::class . ':shipstationOrderShippingUpdate');
$app->post('/integration/zap/authenticate', ZapController::class . ':zapAuthenticate');
$app->get('/integration/zap/getOrders', ZapController::class . ':zapGetOrders');
$app->get('/integration/ai-images', Integration::class . ':getDalleImages');
$app->post('/integration/ai-images', Integration::class . ':saveDalleImages');


$app->group('/integration', function () use ($app) {
    $app->get('/catalog-suppliers', CatalogSupplier::class . ':getCatalogSuppliers');
    $app->post('/catalog-suppliers', CatalogSupplier::class . ':saveSuppliers');
    $app->get('/get-suppliers-status', CatalogSupplier::class . ':getSuppliersStatus');
    $app->get('/get-cron-list', CatalogSupplier::class . ':getCronList');
    $app->get('/download-csv-sample', CatalogSupplier::class . ':downloadCsvSample');
    $app->get('/update-old-catalog', CatalogSupplier::class . ':updateOldCatalog');
    $app->get('', Integration::class . ':pluginIntegration');
    $app->post('/install', Integration::class . ':pluginInstall');
    $app->post('/uninstall', Integration::class . ':pluginUninstall');
    $app->get('/analyticsid', Integration::class . ':getAnalyticstId');
    $app->get('/{slug_code}', Integration::class . ':getPluginInstallStatus');
})->add(new ValidateJWT($container));

$app->group('/quickbook', function () use ($app) {
    $app->post('/importcustomer', QuickBook::class . ':filterByCustomer');
});

//Get ImprintNext add-ons from main server
$app->get('/imprintnext-add-ons', Integration::class . ':getImpAddOns')->add(new ValidateJWT($container));

$app->group(
    '/amazon', function () use ($app) {
        $app->get('/amazonmarketplace', AmazonController::class . ':getAmazonMarketplace');
        $app->get('/category', AmazonController::class . ':getAmazonCategory');
        $app->post('/product', AmazonController::class . ':addNewAmazonProduct');
        $app->get('/order', AmazonController::class . ':getAllAmazonOrders');
        $app->get('/order/{order_id}', AmazonController::class . ':getAmazonOrderDetail');
    }   

);

$app->group(
    '/ai_image', function () use ($app) {
        $app->post('/save', Integration::class . ':saveImagesToLocal');
        $app->get('/clean', Integration::class . ':cleanOldImagesFromServer');
        $app->post('/create-image-variants', Integration::class . ':createImageVariations');
    }
);

