<?php
/**
 * Image Upload Model
 *
 * PHP version 5.6
 *
 * @category  Overlogo Images
 * @package   Images
 * @author    Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @copyright 2020-2021 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 */
namespace App\Modules\OverLogo\Models;

use App\Components\Controllers\Component as ParentController;
/**
 * Browser Image Upload Model
 *
 * @category Browser Images
 * @package  Images
 * @author   Sanjeeb Kumar Dakhinaray <steve@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 */
class OverlogoImage extends \Illuminate\Database\Eloquent\Model
{
    protected $table = 'overlogo_images';
    protected $primaryKey = 'xe_id';
    protected $fillable = ['browser_id', 'file_name'];
    public $timestamps = false;
    
    /**
     * Regenerate File Full URL for front-end
     *
     * @author steve@imprintnext.com
     * @date   27 Oct 202021
     * @return string file url
     */


}
