<?php

/**
 * Product Variant Rel
 *
 * PHP version 5.6
 *
 * @category  Product_Variants
 * @package   Products
 * @author    Debasis Rath <dan@imprintnext.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

namespace App\Modules\Products\Models;

/**
 * ProductVariantRel Class
 *
 * @category Product_Variants
 * @package  Products
 * @author   Debasis Rath <dan@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */

class ProductVariantRel extends \Illuminate\Database\Eloquent\Model
{
    protected $table = 'product_variant_rel';
    protected $primaryKey = null;
    public $incrementing = false;

    protected $fillable = ['variant_id', 'product_id'];

    public $timestamps = false;
    protected $modelPath = 'App\Modules\Products\Models';

    /**
     * Create One-to-One relationship between ProductVariants and ProductOptionRel
     *
     * @author  Debasis Rath <dan@imprintnext.com>
     * @date    16-Nov-2022
     * @return relationship object of product options
     */
    public function variant()
    {
        return $this->belongsTo(
            'App\Modules\Products\Models\ProductVariants',
            'variant_id',
            'xe_id'
        );
    }

    public function getAllVariants($productId = null)
    {
        $query = $this->join('product_variants', 'product_variant_rel.variant_id', '=', 'product_variants.xe_id')->select([
            'product_variants.*', 'product_variant_rel.product_id'
        ]);

        if ($productId) {
            $query->where('product_id', '=', $productId);
        }
        return $query;
    }
}
