<?php

/**
 * Product Options
 *
 * PHP version 5.6
 *
 * @category  Product_Variants
 * @package   Products
 * @author    Debasis Rath <dan@imprintnext.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */

namespace App\Modules\Products\Models;

/**
 * ProductVariants Class
 *
 * @category Product_Variants
 * @package  Products
 * @author   Debasis Rath <dan@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */

class ProductVariants extends \Illuminate\Database\Eloquent\Model
{
    protected $table = 'product_variants';
    protected $primaryKey = 'xe_id';
    protected $guarded = ['xe_id'];
    protected $fillable = ['title','price','sku','image_id','barcode','inventory','weight', 'created_at', 'updated_at'];
    protected $modelPath = 'App\Modules\Products\Models';

    /**
     * Create Many-to-One relationship between ProductVariant and ProductVariantRel
     *
     * @author  Debasis Rath <dan@imprintnext.com>
     * @date    16-Nov-2022
     * @return relationship object of product options
     */
    public function product_variant_rel()
    {
        return $this->hasOne(
            'App\Modules\Products\Models\ProductVariantRel',
            'variant_id',
            'xe_id'
        );
    }
}
