<?php
/**
 * Quotation Payment Model
 *
 * PHP version 5.6
 *
 * @category  Customer_Stripe_Rel
 * @package   Production_Hub
 * @author    Debashri Bhakat <debashrib@riaxe.com>
 * @copyright 2019-2020 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 */

namespace App\Modules\Quotations\Models;

use App\Components\Controllers\Component as ParentController;

/**
 * Customer Stripe Rel
 *
 * @category Customer_Stripe_Rel
 * @package  Production_Hub
 * @author   Debashri Bhakat <debashrib@riaxe.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 */

class CustomerAdditionalInfo extends \Illuminate\Database\Eloquent\Model
{

    protected $primaryKey = 'xe_id';
    protected $table = 'customer_additional_info';
    protected $fillable = ['store_id', 'customer_id' , 'customer_email', 'stripe_customer_id'];
    public $timestamps = false;
}
