<?php
/**
 * This Controller used to save, fetch Big commerce store color value
 * endpoints
 *
 * PHP version 5.6
 *
 * @category  Bigcommerce API
 * @package   Store
 * @author    Dibya <divya@imprintnext.com>
 * @copyright 2021-2022 Riaxe Systems
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @link      http://inkxe-v10.inkxe.io/xetool/admin
 */
namespace SwatchStoreSpace\Controllers;

use ComponentStoreSpace\Controllers\StoreComponent;

/**
 * Store Product Controller
 *
 * @category Bigcommerce API
 * @package  Store
 * @author   Dibya <divya@imprintnext.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://inkxe-v10.inkxe.io/xetool/admin
 */
class StoreColorVariantController extends StoreComponent
{
    /**
     * Instantiate Constructer
     */
    public function __construct()
    {
        parent::__construct();
    }
    /**
     * Get: Get the list of color attributes from the Big-commerce Store
     *
     * @param $response Slim's Response object
     *
     * @author divya@imprintnext.com
     * @date   28 Feb 2022
     * @return Array of Color terms
     */
    public function getColorVariants($response)
    {
        $storeResponse = [
            'status' => 1,
            'color_id' => null,
            'attribute_terms' => [],
        ];
        try {
            $this->getAttributeName();
            $getProductAttributes = $this->getColorAttributes();
            $colorId = 'color';
            if (!empty($getProductAttributes)) {
                $storeResponse = [
                    'status' => 1,
                    'color_id' => $colorId,
                    'attribute_terms' => $getProductAttributes['data'],
                ];
            }
        } catch (\Exception $e) {
            $storeResponse = [
                'status' => 0,
                'message' => message('Variant Data', 'insufficient'),
                'exception' => show_exception() === true ? $e->getMessage() : ''
            ];
        }
        return $storeResponse;
    }
}