<?php
$storePath = ROOTABSPATH ."bigcommerce".DS."lib".DS."config.php";
$storePath = str_replace("//", "/", $storePath);
require_once $storePath;
class StoreComponent
{
	private function getBigcommerceObject(){		
		
		$configXMLpath = $this->getNewXEpath().XECONFIGXML; // xeconfig xml file
		$dom = new DomDocument();
		$dom->load($configXMLpath) or die("Unable to load xml");
		$apiPath = $dom->getElementsByTagName('apipath')->item(0)->nodeValue; 
        $clientId = $dom->getElementsByTagName('clientid')->item(0)->nodeValue;
        $clientSecret= $dom->getElementsByTagName('clientsecret')->item(0)->nodeValue;
        $accessToken = $dom->getElementsByTagName('accesstoken')->item(0)->nodeValue;        
		return new BigcommerceClient($apiPath , $clientId, $clientSecret, $accessToken);	
	}
	protected function checkStoreCredential($data){
		$configXMLpath = $this->getNewXEpath().XECONFIGXML; // xeconfig xml file
		$dom = new DomDocument();
		$dom->load($configXMLpath) or die("Unable to load xml");
		$host = $dom->getElementsByTagName('host')->item(0)->nodeValue;
        $user = $dom->getElementsByTagName('dbuser')->item(0)->nodeValue;
        $password = $dom->getElementsByTagName('dbpass')->item(0)->nodeValue;
        $dbName = $dom->getElementsByTagName('dbname')->item(0)->nodeValue;
        $port = $dom->getElementsByTagName('port')->item(0)->nodeValue;
        if (isset($port) && $port != '') {
            $conn = new mysqli($host, $user, $password, $dbName, $port);
        } else {
            $conn = new mysqli($host, $user, $password);
            $conn->select_db($dbName);
        }
		$status = 0;
		$errorMsg = '';
		try{
	        $bigObject = new BigcommerceClient($data['apipath'] , $data['clientid'], $data['clientsecret'], $data['accesstoken']);
	        $productParams = array();
	        $res = $bigObject->call('GET', 'catalog/products', $productParams);
	        $res = json_decode($res,true);
	        if (!isset($res['status']) || $res['status'] != 401 ) {
	            $status = 1; //'success';

	            //Keep add to cart information along with custom design Id .
	            $sqlBigcommerceCart = 'CREATE TABLE IF NOT EXISTS `bigcommerce_cart` (
	            	`xe_id` int(14) NOT NULL AUTO_INCREMENT ,`product_id` int(11) NOT NULL,`variant_id` int(11) DEFAULT NULL,`cart_id` varchar(255) NOT NULL,`line_item_id` varchar(255) NOT NULL,`custom_design_id` int(11) NOT NULL,`order_id` int(11) NULL DEFAULT NULL , PRIMARY KEY (`xe_id`)) ENGINE=InnoDB DEFAULT CHARSET=latin1;';
	            $conn->query($sqlBigcommerceCart);

	            ///Keep Order and product cache Record of Bigcommerce .
				$sqlBigWebhook_data = 'CREATE TABLE IF NOT EXISTS `big_webhook_data` (`xe_id` int(14) NOT NULL AUTO_INCREMENT,`resource_type` varchar(30) NOT NULL,`resource_id` varchar(40) NOT NULL,PRIMARY KEY (`xe_id`)) ENGINE=InnoDB DEFAULT CHARSET=latin1;';
				$conn->query($sqlBigWebhook_data);
	        }
	    } catch (Exception $e) {
	        $status = 0;
	        $errorMsg = 'AUTHENTICATION_ERROR';
	        $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error :'  . $e->getMessage() . "\n");
	    }
	    return array($status, $errorMsg);
	}

	protected function checkStoreCredWrite($dom){
		$status = false;
		if ($dom->getElementsByTagName('api_url')->item(0)->nodeValue != "" && $dom->getElementsByTagName('accesstoken')->item(0)->nodeValue != "" ) {
			$status = true;
		}
		return $status;
	}

	protected function storeInstallProcess($dom, $baseURL, $basePATH, $dummyData){
    	$apiPath = $dom->getElementsByTagName('apipath')->item(0)->nodeValue; 
        $clientId = $dom->getElementsByTagName('clientid')->item(0)->nodeValue;
        $clientSecret= $dom->getElementsByTagName('clientsecret')->item(0)->nodeValue;
        $accessToken = $dom->getElementsByTagName('accesstoken')->item(0)->nodeValue;        
		$bigObject = new BigcommerceClient($apiPath , $clientId, $clientSecret, $accessToken);
		$createCatRespose = $this->createCollection($bigObject, 'show_in_designer', true);
		$catId = $createCatRespose[2];
		if ($dummyData['setup_type'] == "custom") {			
			$this->createSampleProducts($dom, $bigObject, $dummyData['products'], $dummyData['print_methods'], $catId);
		}
		$this->createWebhooks($bigObject, 'store\/order\/created', 'webhook_order_create', $baseURL);
		$this->createWebhooks($bigObject, 'store\/cart\/lineItem\/created', 'webhook_cart_create', $baseURL);
		$this->createWebhooks($bigObject, 'store\/product\/updated', 'webhook_product_update', $baseURL);
		$returnValue = $this->checkProductCreationStatus($dom, $bigObject ,$catId);
		if($returnValue['0'] == 0){
			$response = array("proceed_next" => false, "message" => "DUMMY_PRODUCT_NOT_CREATED");
	 	}else{
			$response = array("proceed_next" => true, "message" => "DUMMY_PRODUCT_CREATED");
		}
		return $response;
	}

	/*
	- Name : checkCreateDummyProduct
	- it will check if dummy produc has been created or not
	- Return status created or not
	 */
	public function checkCreateDummyProduct($bigObject, $prodHandle, $catId = 0){	
		if(empty($bigObject)){
			$bigObject = $this->getBigcommerceObject();
			$createCatRespose = $this->createCollection($bigObject, 'show_in_designer', true);
			$catId = $createCatRespose[2];
			$prodHandle = "Men Tshirt" ;
		}
		$dummyProdID = 0;    
	    $productParams['categories:in'] = $catId; 
	    $products = $bigObject->call('GET', 'catalog/products',$productParams,'v3');
	    $products = json_decode($products,true);
	    $products = $products['data'];
	    try {	    
		    if (!empty($products)) {
		        foreach ($products as $prod) {
		            if ($prod['name'] == $prodHandle ) {
		                $dummyProdID = $prod['id'];
		            }
		        }
		    }
		} catch (Exception $e) {
			$msg = 'Check domy product Error ' . $e->getMessage();
	            $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . ' : ' . $e->getMessage() . "\n");
		}
	    return $dummyProdID;
	}

	/*
	- Name : checkCreateCollection
	- it will check if custom collection has been created or not
	- Return status created or not
	 */
	private function checkCreateCollection($bigObject, $colName, $isCustom){	
		$thisColID = 0;
		try {
		    if ($isCustom) {
		    	$params = ['name' => $colName];    	
	        	$response = $bigObject->call('GET', 'catalog/categories',$params);
	       		$data = json_decode($response,true);
	       		if(!empty($data['data']) ){
					$thisColID = $data['data'][0]['id'];  
				}
	       	}
	    } catch (Exception $e) {
	            $msg = 'Category creation error: ' . $e->getMessage();
	            $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . ' : ' . $e->getMessage() . "\n");
	        }  
	    return $thisColID;
	}

	/*
	- Name : checkCreateWebhooks
	- it will check if webhooks has been created or not
	- Return status created or not
	 */
	private function checkCreateWebhooks($bigObject, $event, $name, $baseURL){
		$thisHookID = 0;
	    $hooksParam = array(); 
	    $webhooks = $bigObject->call('GET', 'hooks' ,$hooksParam);
	   	$webhooks = json_decode($webhooks,true);
	   	$webhooks = $webhooks['data'];   
	    $webTopic = str_replace('\/', '/', $event);
	    $webURL = $baseURL . "bigcommerce/hooks/" . $name . ".php";
	    foreach ($webhooks as $wbhk) {
	        if ($wbhk['scope'] == $webTopic && $wbhk['destination'] == $webURL) {
	            $thisHookID = $wbhk['id'];
	        }
	    }
	    return $thisHookID;
	}

	/*
	- Name : createCollection
	- it will create a collection in store and assign the dummy product to it
	- Return collection details in json
	 */
	private function createCollection($bigObject, $name, $isCustom){
	    $msg = '';
	    $status = 0;
	    $colID = $this->checkCreateCollection($bigObject, $name, $isCustom);
	    if ($colID == 0) {	                
	        try {
	            if ($isCustom) {
	            	$collectionArray = array(	                
	                    "parent_id" => 0,
	                    "name" => $name,
	                    "description" => "The products under this collection are allowed to be shown in designer tool",
	                    "sort_order" => 3,
	                    "meta_keywords" => [],
	                    "layout_file" => "category.html",
	                    "default_product_sort" => "use_store_settings",
	                    "custom_url" => ["url" => "/".$name."/","is_customized" => false],
	                    "views" => 1050,
	                );
	            	$collectionArray = json_encode($collectionArray,true
	            	);
	                $createCollection = $bigObject->call('POST', 'catalog/categories', $collectionArray,'v3');
	                $createCollection = json_decode($createCollection,true);
	               	$createCollection = $createCollection['data'];
	                if(!empty($createCollection)){	
	                	$status = 1;
	                	$colID = $createCollection['id'];
	                	$msg = $name . " Category has been created.";
	                }
	            }	            
	        } catch (Exception $e){
	            $msg = 'Category creation error: ' . $e->getMessage();
	            $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . ' : ' . $e->getMessage() . "\n");
	        }
	    }
	    else {
	    	$msg = $name . " Category Already available.";
	    	$status = 1;
	    }
	    return array($status,$msg,$colID);
	}
	
	/*
	- Name : createWebhooks
	- it will create webhooks to store
	- Return status created or not
	 */
	private function createWebhooks($bigObject, $event, $name, $baseURL){
	    $msg = '';
	    $status = 0;
	    $webhookID = $this->checkCreateWebhooks($bigObject, $event, $name, $baseURL);
	    if ($webhookID == 0) {
	    	$webTopic = str_replace('\/', '/', $event);
	        $webhookPATH = $baseURL . "bigcommerce/hooks/" . $name . ".php";
	        $webhook_array = array(	          
	                
	                "scope" => $webTopic,
	                "destination" => $webhookPATH,
	        );
	        $webhook_array= json_encode($webhook_array);
	        try {
	            $addWebhook = $bigObject->call('POST', 'hooks', $webhook_array);
	            $addWebhook = json_decode($addWebhook,true);
	            $addWebhook = $addWebhook['data'];
	            if (!empty($addWebhook) && isset($addWebhook['id'])) {
	                $status = 1;
	                $msg = $name.' webhook has been created';	                
	            }
	        } catch (Exception $e) {
	            $msg = 'Webhook error: ' . $e->getMessage();
	            $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . ' : ' . $e->getMessage() . "\n");
	        }
	    } else {
	    	$status = 1;
	        $msg = $name .'Webhook was already created for this store.';
	        $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . "\n");
	    }
	    return array($status,$msg);
	}

	/*
	- Name : checkProductCreationStatus
	- it will check if Step-3 has been completed or not
	- Return status success or error
	 */
	private function checkProductCreationStatus($dom, $bigObject,$catId){	
	    $msg = " - Dummy product is not yet created. \n";
	    $status = 0;
	    $dummyProdChk = $this->checkCreateDummyProduct($bigObject, "Men Tshirt",$catId);
	    if ($dummyProdChk > 0) {
	        $msg = "product is Available";
	        $status = 1;
	    }
	        return array($status,$msg);
	}

	protected function getDummyProductURL($dom){
		$apiPath = $dom->getElementsByTagName('apipath')->item(0)->nodeValue; 
        $clientId = $dom->getElementsByTagName('clientid')->item(0)->nodeValue;
        $clientSecret = $dom->getElementsByTagName('clientsecret')->item(0)->nodeValue;
        $accessToken = $dom->getElementsByTagName('accesstoken')->item(0)->nodeValue;
		$bigObject = new BigcommerceClient($apiPath , $clientId, $clientSecret, $accessToken);		
		$createCatRespose = $this->checkCreateCollection($bigObject, 'show_in_designer', true);
	    $productParams['categories']  = $createCatRespose;
	    $productParams['name'] = 'Men%20Tshirt';
	    $products = $bigObject->call('GET', 'catalog/products',$productParams,'v3');
		$products = json_decode($products,true);
		$products = $products['data'][0];
	    $custom_url = $products['custom_url']['url'];
		$shopData = $bigObject->call('GET', 'store', [],'v2');
	    $shopData = json_decode($shopData,true);
	    return "https://".$shopData['domain'].$custom_url;		
        
	}

	private function createSampleProducts($dom,$bigObject,$prodArr, $printMethods, $catId = 0){
		foreach ($prodArr as $productID) {			
			$productData = file_get_contents(DUMMYDATADIR."product_".$productID.".json");
			$productData = json_decode($productData, true);
			return $this->createDemoProduct($dom,$bigObject,$productData, $printMethods, $catId);
		}
	}

	private function createDemoProduct($dom, $bigObject,$productData, $printMethods, $catId = 0){
		$productTitle = $productData['data']['product_name'];
		$thisProductID = $this->checkCreateDummyProduct($bigObject, $productTitle,$catId);
		if ($thisProductID == 0) {
			$this->scriptAdd($bigObject);
			$hasSize = true;
			$hasColor = true;
			$variantArr = array();
			$sizeKey = 0;
			$colorKey = 0;
			$defaultImage = $productData['data']['store_images'][0]['src'];
			if ($hasSize && $hasColor) {
				foreach ($productData['data']['size'] as $size) {
					$sizeKey = $sizeKey+1;
					$option_values = [];
					$option_values[0] = [
								"label" => $size['name'],
								"option_display_name"=>'size',
							];
					foreach ($productData['data']['color'] as $color) {
						$colorKey = $colorKey+1;
						$option_values[1] = [
								"label" => $color['name'],
								"option_display_name"=>'color',
							] ;
							$thisVar = array(
							"option_values" => $option_values,
							"sku" => "imprintNext_demo_".$sizeKey."_".$colorKey,
							"price" => 100.00,
							"inventory_level" => 1000,
							 "image_url" => $defaultImage,
						);
						$variantArr[] = $thisVar;
						unset($option_values[1]);
					}
				}
			}
			$productImages = array();
			foreach ($productData['data']['store_images'] as $image) {
				$productImages[] = array("image_url" => $image['src'],
					"is_thumbnail" => true,
					"sort_order" => 1,
			);
			}
	        $products_array = array(
	            
	                "name" => $productTitle,
	                "sku" => "IMPRINTNEXT-BIG",
	                "price" => 100,
	                "type" => "physical",
	                "weight" => '10',
	                "categories" => [$catId],
	                "variants" => $variantArr,
	                "images" => $productImages,
	                "stock" =>1000,
	        );
	        $products_array = json_encode($products_array);
	        $addProduct = $bigObject->call('POST', 'catalog/products', $products_array);
	        $addProduct = json_decode($addProduct,true);
	        $addProduct = $addProduct['data'];
	        $thisProductID = $addProduct['id'];
		}
		$this->setBoundaryForDummyProduct($dom, $thisProductID, $productData['data'], $printMethods);
		return $thisProductID;
	}

	private function setBoundaryForDummyProduct($dom, $newProductID, $ParentData, $printMethods) {
		$host = $dom->getElementsByTagName('host')->item(0)->nodeValue;
		$user = $dom->getElementsByTagName('dbuser')->item(0)->nodeValue;
		$password = $dom->getElementsByTagName('dbpass')->item(0)->nodeValue;
		$dbName = $dom->getElementsByTagName('dbname')->item(0)->nodeValue;
		$port = $dom->getElementsByTagName('port')->item(0)->nodeValue;
		try {
	        if (isset($port) && $port != '') {
	            $conn = new mysqli($host, $user, $password, $dbName, $port);
	        } else {
	            $conn = new mysqli($host, $user, $password);
	            $conn->select_db($dbName);
	        }
	    } catch (Exception $e) {
	        $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Database Connection failed: ' . $e->getMessage() . "\n");
	        return array("proceed_next" => false, "message" => "DATABASE_CONN_ERROR");
	        
	    }	    
	    // Insert product id into product_setting table and get xe_id
	    $insertProductSetting = "INSERT INTO product_settings(product_id,is_variable_decoration,is_ruler,is_crop_mark,is_safe_zone,crop_value,safe_value,is_3d_preview,3d_object_file,3d_object,scale_unit_id,store_id) VALUES(".$newProductID."," . $ParentData['is_variable_decoration'] ."," . $ParentData['is_ruler']. "," . $ParentData['is_crop_mark']. "," . $ParentData['is_safe_zone']. "," . $ParentData['crop_value']. "," . $ParentData['safe_value']. "," . $ParentData['is_3d_preview']. ",'" . $ParentData['3d_object_file']. "','" . $ParentData['3d_object']. "'," . $ParentData['scale_unit_id']. " , 1)";
        $conn->query($insertProductSetting);
        $prodSetID = mysqli_insert_id($conn);
        
        //Assign product image
        $productimageQRY = "INSERT INTO `product_image_settings_rel` (`product_setting_id`, `product_image_id`) VALUES (".$prodSetID."," . $ParentData['product_image_id'] .")";
        $conn->query($productimageQRY);
        // insert print profile and product id relationship
        $insertRelation = "INSERT INTO print_profile_product_setting_rel(print_profile_id, product_setting_id) VALUES";
        foreach ($printMethods as $key => $rel) {
        	if ($key > 0) {
        		$insertRelation .= ", "; 
        	}
        	 $insertRelation .= "(".$rel."," . $prodSetID. ")";
        }
        $conn->query($insertRelation);

        // Insert sides into product_sides table and get side id
        foreach ($ParentData['sides'] as $side) {
		    $insertSideSetting = "INSERT INTO product_sides(product_setting_id,side_name,side_index,product_image_dimension,is_visible,product_image_side_id) VALUES(".$prodSetID.",'" . $side['name'] ."','" . $side['index']. "','" . $side['dimension']. "'," . $side['is_visible']. "," . $side['image']['id']. ")";
	        $conn->query($insertSideSetting);
	        $sideSetID = mysqli_insert_id($conn);
	        
	        $setting = $side['decoration_settings'][0];
	        // Insert data for each sides decoration settings
	        $insertDecoSetting = "INSERT INTO product_decoration_settings(product_setting_id,product_side_id,name,dimension,print_area_id,sub_print_area_type,custom_min_height,custom_max_height,custom_min_width,custom_max_width,is_border_enable,is_sides_allow) VALUES(".$prodSetID."," . $sideSetID .",'" . $setting['name']. "','" . $setting['dimension']. "','" . $setting['print_area_id']. "','" . $setting['sub_print_area_type']. "','" . $setting['min_height']."','" . $setting['max_height']."','" . $setting['min_width']."','" . $setting['max_width']."','" . $setting['is_border_enable']."','" . $setting['is_sides_allow']. "')";
	        $conn->query($insertDecoSetting);
	        $decoSetID = mysqli_insert_id($conn);

	        $insertMethodSetRel = "INSERT INTO print_profile_decoration_setting_rel(print_profile_id, decoration_setting_id) VALUES";
	        foreach ($printMethods as $key => $rel) {
	        	if ($key > 0) {
	        		$insertMethodSetRel .= ", "; 
	        	}
	        	 $insertMethodSetRel .= "(".$rel."," . $decoSetID. ")";
	        }
	        $queryStatusPDM = $conn->query($insertMethodSetRel);
        }
        return $queryStatusPDM;

	}

	public function getStoreLangCurrency($storeId, $dom){
	    $apiPath = $dom->getElementsByTagName('apipath')->item(0)->nodeValue; 
        $clientId = $dom->getElementsByTagName('clientid')->item(0)->nodeValue;
        $clientSecret = $dom->getElementsByTagName('clientsecret')->item(0)->nodeValue;
        $accessToken = $dom->getElementsByTagName('accesstoken')->item(0)->nodeValue;
        $storeParams = array();
        $bigObject = new BigcommerceClient($apiPath , $clientId, $clientSecret, $accessToken);
	    $shopData = $bigObject->call('GET', 'store', $storeParams,'v2');
	    $shopData = json_decode($shopData,true);
	    try {
	    	if(!empty($shopData)){
	    		$storeInfo = array("currency"=> $shopData['currency'], "language"=> $shopData['language'], "storeId" => 1);		    
	    	}
		    
		}catch (Exception $e) {
	            $msg = 'Store Language Currency Error: ' . $e->getMessage();
	            $this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error : ' . $msg . ' : ' . $e->getMessage() . "\n");
	            $storeInfo = array("currency"=> 'USD', "language"=> 'EN', "storeId" => 1);
	        }
	        return json_encode($storeInfo);
	}

	/**
     * GET: Bigcommerce Theme Details
     *
     * @author divya@imprintnext.com
     * @date   25 March 2022
     * @return category Id
     */
    public function customScriptJquery($bigObject)
    {
        $scriptContent = array(
                        "name" => "Jquery",
                        "description" => "Include jquery library",
                        "src" => 'https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js',
                        "auto_uninstall" => true,
                        "load_method" => 'default',
                        "location" => 'footer',
                        "visibility" => 'all_pages',
                        "kind" => "src",
                        "consent_category" => "essential"
                );
		$scriptInput = json_encode($scriptContent);	
        $scriptPostArray = $bigObject->call('POST', 'content/scripts', $scriptInput, 'v3');
        return json_decode($scriptPostArray,true);
     }

	 /**
     * GET: Bigcommerce Theme Details
     *
     * @author divya@imprintnext.com
     * @date   25 March 2022
     * @return category Id
     */
    public function customScriptProduct($bigObject)
    {
		$customizePath = $this->getNewXEURL() . "bigcommerce/scripts/customize.js";
        $scriptContent = array(
                        "name" => "Customize Product",
                        "description" => "functionality for customize button",
                        "src" => $customizePath,
                        "auto_uninstall" => true,
                        "load_method" => 'default',
                        "location" => 'footer',
                        "visibility" => 'storefront',
                        "kind" => "src",
                        "consent_category" => "essential"
                );
		$scriptInput = json_encode($scriptContent);	
        $scriptPostArray = $bigObject->call('POST', 'content/scripts', $scriptInput, 'v3');
        return json_decode($scriptPostArray,true);
     }

	 /**
     * GET: Bigcommerce Theme Details
     *
     * @author divya@imprintnext.com
     * @date   25 March 2022
     * @return category Id
     */
    public function customScriptCart($bigObject)
    {
		$cartPath = $this->getNewXEURL() . "bigcommerce/scripts/cart.js";
        $scriptContent = array(
                        "name" => "Cart data",
                        "description" => "design product in cart page",
                        "src" => $cartPath,
                        "auto_uninstall" => true,
                        "load_method" => 'default',
                        "location" => 'footer',
                        "visibility" => 'all_pages',
                        "kind" => "src",
                        "consent_category" => "essential"
                );
		$scriptInput = json_encode($scriptContent);
        $scriptPostArray = $bigObject->call('POST', 'content/scripts', $scriptInput, 'v3');
        return json_decode($scriptPostArray,true);
     }

	 public function scriptAdd($bigObject)
	 {
		$this->customScriptJquery($bigObject);
		$this->customScriptCart($bigObject);
		$this->customScriptProduct($bigObject);
		return 1;
	 }

	 protected function getNewXEURL(){
		$baseURLData = $this->getBaseUrl();
		$baseURL = $baseURLData[1];
		$inkXEpkgDIR = str_replace(SETUPFOLDERNAME.DS, '', ROOTABSPATH);
		$tempConfigFile = $inkXEpkgDIR."imprint_details.json";
		if (file_exists($tempConfigFile)) {
			$setupDetails = json_decode(file_get_contents($tempConfigFile), true) ;
			if (is_array($setupDetails) && $setupDetails['designer_dir'] != '') {
				$newXEtoolURL = $baseURL.$setupDetails['designer_dir']. DS;
			}
		}
		return $newXEtoolURL;
	}
}

?>