<?php

use Magento\Framework\App\Bootstrap;

$docAbsPath = getcwd();
if (strpos($_SERVER['SCRIPT_FILENAME'], '/pub') !== false && strpos($_SERVER['SCRIPT_FILENAME'], '/public_html') == false) {
	if (file_exists($docAbsPath . '/../../../../app/bootstrap.php')) {
		require_once $docAbsPath . '/../../../../app/bootstrap.php';
	}
} else {
	if (file_exists($docAbsPath . '/../../../app/bootstrap.php')) {
		require_once $docAbsPath . '/../../../app/bootstrap.php';
	}
}

class StoreComponent
{
	/*
	- Name : objectManagerInstance
	- it will create a object manager instance for magento 2.x
	- Return object
	 */
	private function objectManagerInstance()
	{
		$bootstrap = Bootstrap::create(BP, $_SERVER);
		$objectManager = $bootstrap->getObjectManager();
		$appState = $objectManager->get("Magento\Framework\App\State");
		$appState->setAreaCode('frontend');
		return $objectManager;
	}

	/*
	- Name : CreateStoreCredential
	- it will create a user access token to communicate with store
	- Return access token key
	 */
	protected function CreateStoreCredential($data)
	{
		$result = [];
		if (isset($data) && isset($data['type'])) {
			extract($data);
			$objectManager = $this->objectManagerInstance();
			$storeVersion = $objectManager->get('Magento\Framework\App\ProductMetadataInterface')->getVersion();
			if ($type == 'n') {
				$integrationExists = $objectManager->get('Magento\Integration\Model\IntegrationFactory')->create()->load($name, 'name')->getData();
				if (empty($integrationExists)) {
					$integrationData = array(
						'name' => $name,
						'email' => $email,
						'status' => '1',
						'endpoint' => 'XEPATH',
						'setup_type' => '0',
					);
					try {
						// Code to create Integration
						$integrationFactory = $objectManager->get('Magento\Integration\Model\IntegrationFactory')->create();
						$integration = $integrationFactory->setData($integrationData);
						$integration->save();
						$integrationId = $integration->getId();
						$consumerName = 'Integration' . $integrationId;
						// Code to create consumer
						$oauthService = $objectManager->get('Magento\Integration\Model\OauthService');
						$consumer = $oauthService->createConsumer(['name' => $consumerName]);
						$consumerId = $consumer->getId();
						$integration->setConsumerId($consumer->getId());
						$integration->save();
						// Code to grant permission
						$authrizeService = $objectManager->get('Magento\Integration\Model\AuthorizationService');
						$authrizeService->grantAllPermissions($integrationId);
						// Code to authorize
						$token = $objectManager->get('Magento\Integration\Model\Oauth\Token');
						$uri = $token->createVerifierToken($consumerId);
						$token->setType('access');
						$token->save();
						$accessToken = $token->getToken();
						$msg = "";
						$status = 1;
					} catch (Exception $e) {
						$msg = $e->getMessage();
						$objectManager->get('Psr\Log\LoggerInterface')->debug($msg);
						$status = 0;
					}
				} else {
					$msg = "";
					$status = 1;
					$consumerId = $objectManager->get('Magento\Integration\Model\IntegrationFactory')->create()->load($integrationExists['integration_id'])->getConsumerId();
					$connection = $objectManager->get('Magento\Framework\App\ResourceConnection')->getConnection('\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION');
					$tableName = $connection->getTableName('oauth_token');
					$token = $connection->fetchAll("SELECT token FROM " . $tableName . " WHERE consumer_id='" . $consumerId . "' LIMIT 1;");
					$accessToken = $token[0]['token'];
				}
			} else if ($type == 'e') {
				$msg = "";
				$status = 1;
				$consumerId = $objectManager->get('Magento\Integration\Model\IntegrationFactory')->create()->load($integration_id)->getConsumerId();
				$connection = $objectManager->get('Magento\Framework\App\ResourceConnection')->getConnection('\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION');
				$tableName = $connection->getTableName('oauth_token');
				$token = $connection->fetchAll("SELECT token FROM " . $tableName . " WHERE consumer_id='" . $consumerId . "' LIMIT 1;");
				$accessToken = $token[0]['token'];
			}

			$storeManager = $objectManager->get('\Magento\Store\Model\StoreManagerInterface');
			$apiPath = $storeManager->getStore()->getBaseUrl();

			$apiVersion = $this->getApiVersion($apiPath, $accessToken);

			$apiPath = $apiPath."rest/".$apiVersion;
			
			if ($accessToken && $status == 1) {
				$result = [
					'api_user' => $email,
					'api_integration_name' => $name,
					'api_access_token' => $accessToken,
					'magento_version' => $storeVersion,
					'api_version' => $apiVersion,
					'api_path' => $apiPath
				];
			}
		}
		return $result;
	}

	/*
	- Name : checkStoreCredential
	- it will check if store access has been created or not
	- Return status created or not
	 */
	protected function checkStoreCredential($data)
	{
		$magentoStoreLocation = $this->getStoreLocation();
		if ($magentoStoreLocation == 0) {
			$status = 1;
		} else {
			extract($data);
			$errorMsg = '';
			try {
				$objectManager = $this->objectManagerInstance();
				$integrationExists = $objectManager->get('Magento\Integration\Model\IntegrationFactory')->create()->load($integration_name, 'name')->getData();
				if (is_array($integrationExists)) {
					$status = 1; //'success';
				}
			} catch (Exception $e) {
				$status = 0;
				$errorMsg = 'AUTHENTICATION_ERROR';
				$this->xe_log("\n" . date("Y-m-d H:i:s") . ': Error :'  . $e->getMessage() . "\n");
			}
		}

		return array($status, $errorMsg);
	}

	/*
	- Name : checkStoreCredWrite
	- it will check if store access has been written to XML or not
	- Return status created or not
	 */
	protected function checkStoreCredWrite($dom)
	{
		$status = false;
		if ($dom->getElementsByTagName('api_access_token')->item(0)->nodeValue != "") {
			$status = true;
		}
		return $status;
	}

	/*
	- Name : storeInstallProcess
	- it will create a CMS page and a demo product
	- Return status created or not
	 */
	protected function storeInstallProcess($dom, $baseURL, $basePATH, $dummyData)
	{
		
		// $status = $this->checkCreateDummyProduct($dom);
		/*Create a CMS page with an iFrame to load designer tool*/
		//$this->createCmsPage($dom);
		/*Create a product attribute set and attributes*/
		//$this->createAttributes();
		/*Create dummy product*/
		if ($dummyData['setup_type'] == "auto") {
			$status = $this->createSampleProducts($dom, array(9214), $dummyData['print_methods']);
		} else {
			$status = $this->createSampleProducts($dom, $dummyData['products'], $dummyData['print_methods']);
		}
		if ($status == 0) {
			$response = array("proceed_next" => false, "message" => "MODULE_NOT_INSTALLED");
		} else {
			$response = array("proceed_next" => true, "message" => "DUMMY_PRODUCT_CREATED");
		}
		return $response;
	}


	/*
	- Name : createAttributeSet
	- it will create a product attribute set.
	- Return status created or not
	 */
	private function createAttributeSet($setName)
	{
		$status = 0;
		try {
			$objectManager = $this->objectManagerInstance();
			$attributeSet = $objectManager->create('Magento\Eav\Model\Entity\Attribute\Set');
			$entityTypeId = $objectManager->create('Magento\Eav\Model\Entity\Type')->loadByCode('catalog_product')->getId();
			$attributeSet->setData(array(
				'attribute_set_name' => $setName,
				'entity_type_id' => $entityTypeId,
				'sort_order' => 200,
			));
			$attributeSet->validate();
			$attributeSet->save();
			$baseSetId = 4;
			$attributeSet->initFromSkeleton($baseSetId)->save();
			$status = 1;
		} catch (Exception $e) {
			$msg = '- Unable to create attribute set.';
			$status = 0;
			$this->xe_log("\n" . date("Y-m-d H:i:s") . ':' . $msg);
		}
		return $status;
	}

	/*
	- Name : createSampleProducts
	- it will create dummy products.
	- Return status created or not
	 */
	private function createSampleProducts($dom, $prodArr, $printMethods)
	{
		$status = 0;
		foreach ($prodArr as $productID) {
			$productData = file_get_contents(DUMMYDATADIR . "product_" . $productID . ".json");
			$productData = json_decode($productData, true);
			$createdProductId = $this->createProduct($dom, $productData, $printMethods);
			if ($createdProductId > 0) {
				$status = $this->setBoundaryForDummyProduct($dom, $createdProductId, $productData['data'], $printMethods);				
			}
		}
		return $status;
	}

	/*
	- Name : createProduct
	- it will create a product attribute set.
	- Return status created or not
	 */
	private function createProduct($dom, $productData)
	{
		$configProductId = $this->checkCreateDummyProduct($dom);
		return $configProductId;
	}



	/*
	- Name : setBoundaryForDummyProduct
	- it will set boundary for newly created product.
	- Return status set or not
	 */
	private function setBoundaryForDummyProduct($dom, $newProductID, $ParentData, $printMethods)
	{
		$host = $dom->getElementsByTagName('host')->item(0)->nodeValue;
		$user = $dom->getElementsByTagName('dbuser')->item(0)->nodeValue;
		$password = $dom->getElementsByTagName('dbpass')->item(0)->nodeValue;
		$dbName = $dom->getElementsByTagName('dbname')->item(0)->nodeValue;
		// $port = $dom->getElementsByTagName('port')->item(0)->nodeValue;
		$status = 1;
		try {
			//error_reporting(0);
			if (isset($port) && $port != '') {
				$conn = new mysqli($host, $user, $password, $dbName, $port);
			} else {
				$conn = new mysqli($host, $user, $password);
				$conn->select_db($dbName);
			}
		} catch (Exception $e) {
			$error = "- Database Connection failed. Error: " . $e->getMessage() . "\n";
			$this->xe_log("\n" . date("Y-m-d H:i:s") . ': Database Connection failed: ' . $e->getMessage() . "\n");
			$response = array("proceed_next" => false, "message" => "DATABASE_CONN_ERROR");
			return $response;
			exit();
		}
		
		// Insert product id into product_setting table and get xe_id
		$insertProductSetting = "INSERT INTO product_settings(product_id,is_variable_decoration,is_ruler,is_crop_mark,is_safe_zone,crop_value,safe_value,is_3d_preview,3d_object_file,3d_object,scale_unit_id,store_id) VALUES(" . $newProductID . "," . $ParentData['is_variable_decoration'] . "," . $ParentData['is_ruler'] . "," . $ParentData['is_crop_mark'] . "," . $ParentData['is_safe_zone'] . "," . $ParentData['crop_value'] . "," . $ParentData['safe_value'] . "," . $ParentData['is_3d_preview'] . ",'" . $ParentData['3d_object_file'] . "','" . $ParentData['3d_object'] . "'," . $ParentData['scale_unit_id'] . " , 1)";
		$queryStatusPS = $conn->query($insertProductSetting);
		$prodSetID = mysqli_insert_id($conn);
		if ($queryStatusPS == false) {
			//- Data not inserted to domain_store_rel table.			
			$status = 0;
		}
		//Assign product image
		$productimageQRY = "INSERT INTO `product_image_settings_rel` (`product_setting_id`, `product_image_id`) VALUES (" . $prodSetID . "," . $ParentData['product_image_id'] . ")";
		$queryRun = $conn->query($productimageQRY);
		// insert print profile and product id relationship
		$insertRelation = "INSERT INTO print_profile_product_setting_rel(print_profile_id, product_setting_id) VALUES";
		foreach ($printMethods as $key => $rel) {
			if ($key > 0) {
				$insertRelation .= ", ";
			}
			$insertRelation .= "(" . $rel . "," . $prodSetID . ")";
		}
		$queryStatusPPM = $conn->query($insertRelation);

		// Insert sides into product_sides table and get side id
		foreach ($ParentData['sides'] as $side) {
			if($side['index'] == ''){
				$side['index']  = 0;
			}
			$insertSideSetting = "INSERT INTO product_sides(product_setting_id,side_name,side_index,product_image_dimension,is_visible,product_image_side_id) VALUES(" . $prodSetID . ",'" . $side['name'] . "','" . $side['index'] . "','" . $side['dimension'] . "'," . $side['is_visible'] . "," . $side['image']['id'] . ")";
			$queryStatusS = $conn->query($insertSideSetting);
			$sideSetID = mysqli_insert_id($conn);
			if ($queryStatusS == false) {
				//- Data not inserted to domain_store_rel table.
				$status = 0;
			}
			$setting = $side['decoration_settings'][0];
			// Insert data for each sides decoration settings
			$insertDecoSetting = "INSERT INTO product_decoration_settings(product_setting_id,product_side_id,name,dimension,print_area_id,sub_print_area_type,custom_min_height,custom_max_height,custom_min_width,custom_max_width,is_border_enable,is_sides_allow) VALUES(" . $prodSetID . "," . $sideSetID . ",'" . $setting['name'] . "','" . $setting['dimension'] . "','" . $setting['print_area_id'] . "','" . $setting['sub_print_area_type'] . "','" . 0 . "','" . 0 . "','" . 0 . "','" . 0 . "','" . $setting['is_border_enable'] . "','" . $setting['is_sides_allow'] . "')";
			$queryStatusDS = $conn->query($insertDecoSetting);
			$decoSetID = mysqli_insert_id($conn);

			$insertMethodSetRel = "INSERT INTO print_profile_decoration_setting_rel(print_profile_id, decoration_setting_id) VALUES";
			foreach ($printMethods as $key => $rel) {
				if ($key > 0) {
					$insertMethodSetRel .= ", ";
				}
				$insertMethodSetRel .= "(" . $rel . "," . $decoSetID . ")";
			}
			$queryStatusPDM = $conn->query($insertMethodSetRel);
		}
		return $status;
	}

	/*
	- Name : getDummyProductURL
	- it will fetch and return store URL.
	- Return store URL
	 */
	protected function getDummyProductURL($dom)
	{
		// Starting session
		session_start();
		$apiPath = $dom->getElementsByTagName('api_path')->item(0)->nodeValue;
		$productURL =  explode("rest", $apiPath)[0];
		$productURL = $productURL . "men-tshirt.html";
		return $productURL;
	}

	public function getStoreLangCurrency($storeId, $dom = "")
	{

		$apiPath = $dom->getElementsByTagName('api_path')->item(0)->nodeValue;
		$api_access_token = $dom->getElementsByTagName('api_access_token')->item(0)->nodeValue;

		$apiPath = $apiPath . "/store/storeConfigs";
		$data = $this->magentoCURL($apiPath, $api_access_token, 0); // Get Response
		$data = json_decode($data, true);
		foreach ($data as $langData) {
			if ($langData['code']) {
				$currency = $langData['base_currency_code'];
				$language = $langData['locale'];
				$storeId = $langData['website_id'];
			}
		}
		
		$response = [
			'currency' => $currency,
			'language' => $language,
			'storeId'  => $storeId,
		];
		return json_encode($response);
	}

	public function checkCreateDummyProduct($dom)
	{
		$apiPath = $dom->getElementsByTagName('api_path')->item(0)->nodeValue;
		$existProduct = 0;
		$api_access_token = $dom->getElementsByTagName('api_access_token')->item(0)->nodeValue;
		$searchParam = "/products?searchCriteria[filter_groups][0][filters][0][field]=name&searchCriteria[filter_groups][0][filters][0][value]=%25Watch%25&searchCriteria[filter_groups][0][filters][0][condition_type]=like&searchCriteria[filter_groups][0][filters][1][field]=name&searchCriteria[filter_groups][0][filters][1][value]=%25Men%20Tshirt%25&searchCriteria[filter_groups][0][filters][1][condition_type]=like";
		$apiPath = $apiPath . $searchParam;

		$data = $this->magentoCURL($apiPath, $api_access_token, 0); // Get Resonse
		$data = json_decode($data, true);
		$items = $data['items'];
		if (!empty($items)) {
			foreach ($items as $value) {
				if ($value['type_id'] == 'configurable') {
					$configProductId = $value['id'];
				}
			}
			$existProduct = $configProductId;
		}
		return $existProduct;
	}

	public function getStoreLocation()
	{
		$docAbsPath = getcwd();
		$status = 0;
		if (file_exists($docAbsPath . '/../../../../app/bootstrap.php')) {
			$status = 1;
		} elseif (file_exists($docAbsPath . '/../../../app/bootstrap.php')) {
			$status = 1;
		} else {
			$status = 0;
		}
		return $status;
	}

	public function magentoCURL( $apiPath, $accessToken, $http)
	{
		$curl = curl_init();
		if($http == 1){
			$apiPath = $apiPath . '/store/storeGroups';
		}
		curl_setopt_array($curl, array(
			CURLOPT_URL => $apiPath,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_HTTPHEADER => array(
				'Authorization: Bearer ' . $accessToken
			),
		));
		$response = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);
		if($http ==  1){
			return $httpcode;
		}else{
			return $response;
		}
		
	}

	

	public function validateStoreCredential($data)
	{
		$status = 0;
		$apiPath = $data['api_path'];
		$integrationName = $data['integration_name'];
		$accessToken = $data['access_token'];
		$checkApiPath = explode("//rest", $apiPath);

		if (sizeof($checkApiPath) > 1) {
			$apiPath = str_replace("//rest", "/rest", $apiPath);
		}

		$apiVersion = $this->getApiVersion($apiPath, $accessToken);
		$apiPath = $apiPath . '/rest/' . $apiVersion;

		if(strpos($apiPath, "//rest") !== false){
			$apiPath = str_replace("//rest", "/rest", $apiPath);
		}

		$httpcode = $this->magentoCURL($apiPath, $accessToken, 1);
		
		if ($httpcode == 200 || $httpcode == 201) {
			$status = 1;
			$result = [
				'api_integration_name' => $integrationName,
				'api_access_token' => $accessToken,
				'api_version' => $apiVersion,
				'api_path' => $apiPath
			];
		} else {
			$result = [];
			$status = 0;
		}
		return ["status" => $status, 'data' => $result];
	}

	public function getApiVersion($apiPath,$accessToken){
		
		$storeVersion = 'V1';
		$apiPath = $apiPath . '/rest/' . $storeVersion;
		$httpcode = $this->magentoCURL($apiPath, $accessToken, 1);
		if ($httpcode != 200) {
			$storeVersion = 'V2';
			$apiPath = $apiPath . '/rest/' . $storeVersion;
			$httpcode = $this->magentoCURL($apiPath, $accessToken, 1);
			if ($httpcode != 200) {
				$storeVersion = 'V3';
				$apiPath = $apiPath . '/rest/' . $storeVersion;
				$httpcode = $this->magentoCURL($apiPath, $accessToken, 1);
			}
		}
		return $storeVersion;
	}
}
