-- Add new columns in print_profile_engrave_settings table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'print_profile_engrave_settings'
		AND table_schema = DATABASE()
        AND column_name IN('is_BWGray_enabled', 'is_black_white')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `print_profile_engrave_settings` ADD `is_BWGray_enabled` TINYINT(1) NULL DEFAULT '0' AFTER `is_engrave_preview_image`, ADD `is_black_white` TINYINT(1) NULL DEFAULT '0' AFTER `is_BWGray_enabled`, ADD `is_gary_scale` TINYINT(1) NULL DEFAULT '0' AFTER `is_black_white`;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Changed column data type to varchar from enum

ALTER TABLE `price_advanced_price_settings` CHANGE `area_calculation_type` `area_calculation_type` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'design_area, bound_area, print_area';
UPDATE `print_area_types` SET `name` = 'Without bleed Mark' WHERE `print_area_types`.`name` = 'Custom';
INSERT INTO `print_area_types` (`xe_id`, `name`, `file_name`, `is_custom`, `store_id`) VALUES (NULL, 'With bleed Mark', NULL, '1', '1');

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'print_areas'
        AND table_schema = DATABASE()
        AND column_name IN('bleed_width', 'safe_width', 'bleed_height', 'safe_height')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `print_areas` ADD `bleed_width` VARCHAR(30) NULL DEFAULT NULL AFTER `store_id`, ADD `bleed_height` VARCHAR(30) NULL DEFAULT NULL AFTER `bleed_width`, ADD `safe_width` VARCHAR(30) NULL DEFAULT NULL AFTER `bleed_height`, ADD `safe_height` VARCHAR(30) NULL DEFAULT NULL AFTER `safe_width`;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'product_decoration_settings'
        AND table_schema = DATABASE()
        AND column_name IN('bleed_mark_data', 'shape_mark_data')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `product_decoration_settings` ADD `bleed_mark_data` TEXT NULL DEFAULT NULL AFTER `locations`, ADD `shape_mark_data` TEXT NULL DEFAULT NULL AFTER `bleed_mark_data`;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/*Add 'is_defined' column in categories table*/

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'categories'
        AND table_schema = DATABASE()
        AND column_name IN('is_defined')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `categories` ADD `is_defined` tinyint(1) DEFAULT 1 COMMENT '0-delete, 1- not delete';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Table structure for table customer_internal_notes 

CREATE TABLE IF NOT EXISTS `customer_internal_notes` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` INT(4) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `title` VARCHAR(255)  NOT NULL, 
  `note` TEXT NOT NULL,
  `user_type` VARCHAR(50)  NOT NULL COMMENT 'admin, agent', 
  `user_id` INT(11) NOT NULL , 
  `seen_flag` TINYINT(1) NOT NULL DEFAULT '0',
  `created_date` DATETIME NOT NULL,
  PRIMARY KEY (xe_id),
  KEY customer_internal_notes (customer_id,created_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table `customer_internal_note_files` 

CREATE TABLE IF NOT EXISTS `customer_internal_note_files` ( 
  `xe_id` INT(11) NOT NULL AUTO_INCREMENT , 
  `note_id` INT(11) NOT NULL ,
  `file` VARCHAR(255) NOT NULL ,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- Add new column slug in production_status table

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'admin_users'
        AND table_schema = DATABASE()
        AND column_name IN('language_selected')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE admin_users ADD language_selected varchar(60) NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- Data for the table `production_email_templates` 

INSERT INTO production_email_templates (store_id, module_id, template_type_name, subject, message, is_configured)
SELECT '1','3','send_po', 'Purchase Order', '<span>Hello {contact_name},</span><br><br><span>A purchase odrder ID#: {order_id} is created. Please check the attached PDF for the purchase order details.</span><br><br><span>Thanks</span>', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, template_type_name FROM production_email_templates 
where store_id='1' and module_id='3' and template_type_name='send_po');

-- Data for the table `production_template_abbriviations` 

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{po_id}','3'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations 
where abbr_name='{po_id}' and module_id='3');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{contact_name}','3'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations 
where abbr_name='{contact_name}' and module_id='3');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{vendor_name}','3'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations 
where abbr_name='{vendor_name}' and module_id='3');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{vendor_email}','3'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations 
where abbr_name='{vendor_email}' and module_id='3');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{created_date}','3'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations 
where abbr_name='{created_date}' and module_id='3');

INSERT INTO production_template_abbriviations (abbr_name, module_id)
SELECT '{expected_date_of_delivery}','3'
FROM DUAL
WHERE NOT EXISTS (SELECT abbr_name, module_id FROM production_template_abbriviations 
where abbr_name='{expected_date_of_delivery}' and module_id='3');


-- Adding default data for table `production_hub_settings` 

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'time_format', '24', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='4' and setting_key='time_format');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'working_hours', '{"starts_at":"10:30","ends_at":"19:30"}', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='4' and setting_key='working_hours');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'weekends', '["sat"]', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='4' and setting_key='weekends');

INSERT INTO production_hub_settings (store_id, module_id, setting_key, setting_value, flag)
SELECT '1', '4', 'is_barcode_enable', 'false', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, setting_key FROM production_hub_settings  
where store_id='1' and module_id='4' and setting_key='is_barcode_enable');


-- Table structure for table `production_job_holidays` 

CREATE TABLE IF NOT EXISTS `production_job_holidays` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(4) NOT NULL,
  `holiday_name` varchar(255) NULL,
  `day` varchar(50) NULL,
  `date` date NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Add indexing in quotations table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.STATISTICS
        WHERE table_name = 'quotations'
        AND table_schema = DATABASE()
        AND index_name =  'quotation_index_key_01'
    ) <= 0,
    "ALTER TABLE quotations ADD INDEX quotation_index_key_01 (quote_id, customer_id, customer_name, customer_email, title, status_id);",
  "SELECT 1"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


-- Add indexing in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.STATISTICS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND index_name =  'quote_items_index_key_01'
    ) <= 0,
     "ALTER TABLE quote_items ADD INDEX quote_items_index_key_01 (quote_id, product_id);",
  "SELECT 1"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- Add indexing in purchase_order table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.STATISTICS
        WHERE table_name = 'purchase_order'
        AND table_schema = DATABASE()
        AND index_name =  'purchase_order_index_key_01'
    ) <= 0,
    "ALTER TABLE purchase_order ADD INDEX purchase_order_index_key_01 (po_id, status_id);",
  "SELECT 1"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add indexing in vendor table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.STATISTICS
        WHERE table_name = 'vendor'
        AND table_schema = DATABASE()
        AND index_name =  'vendor_index_key_01'
    ) <= 0,
    "ALTER TABLE vendor ADD INDEX vendor_index_key_01 (company_name, contact_name, email, country_code, state_code, city, zip_code);",
  "SELECT 1"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add new column is_ready_to_send in quotations table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quotations'
        AND table_schema = DATABASE()
        AND column_name IN('is_ready_to_send')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quotations ADD is_ready_to_send TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0-not ready, 1-ready';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;


ALTER TABLE `quotations` CHANGE `customer_id` `customer_id` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL;
ALTER TABLE `quotations` CHANGE `shipping_id` `shipping_id` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL;
ALTER TABLE `quotations` CHANGE `created_by` `created_by` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'admin, customer, agent';
ALTER TABLE `quotations` CHANGE `quote_source` `quote_source` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'admin, tool, form';
ALTER TABLE `quotations` CHANGE `title` `title` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL;
ALTER TABLE `quotations` CHANGE `ship_by_date` `ship_by_date` DATETIME NULL;
ALTER TABLE `quotations` CHANGE `exp_delivery_date` `exp_delivery_date` DATETIME NULL;
ALTER TABLE `quotations` CHANGE `is_artwork` `is_artwork` TINYINT(1) NOT NULL DEFAULT '0';
ALTER TABLE `quotations` CHANGE `is_rush` `is_rush` TINYINT(1) NOT NULL DEFAULT '0';
ALTER TABLE `quotations` CHANGE `rush_type` `rush_type` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT 'percentage, flat';
ALTER TABLE `quotations` CHANGE `draft_flag` `draft_flag` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0-send to customer,1-save as draft';
ALTER TABLE `quotations` CHANGE `created_by_id` `created_by_id` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL;


ALTER TABLE `quote_items` CHANGE `artwork_type` `artwork_type` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT 'uploaded_file, design_tool, no_decoration';
ALTER TABLE `quote_items` CHANGE `quote_id` `quote_id` VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL;
ALTER TABLE `quote_items` CHANGE `product_id` `product_id` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL;
ALTER TABLE `quote_items` CHANGE `quantity` `quantity` INT(11) NULL;
ALTER TABLE `quote_items` CHANGE `design_cost` `design_cost` FLOAT(10,2) NULL;
ALTER TABLE `quote_items` CHANGE `unit_total` `unit_total` FLOAT(10,2) NULL; 

ALTER TABLE `quote_log` CHANGE `user_id` `user_id` INT(11) NULL COMMENT 'i.e agent data in case of agent assignment';


-- Add new column quotation_request_id in quotations table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quotations'
        AND table_schema = DATABASE()
        AND column_name IN('quotation_request_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quotations ADD quotation_request_id INT(11) NULL"
));
PREPARE stmt FROM @s; 
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column is_decorated_product in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('is_decorated_product')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD is_decorated_product TINYINT(1) NULL DEFAULT '0' COMMENT '0- not decorated product, 1- decorated product';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column is_redesign in quote_items table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_items'
        AND table_schema = DATABASE()
        AND column_name IN('is_redesign')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_items ADD is_redesign TINYINT(1) NULL DEFAULT '1' COMMENT '0- no redesign option, 1- redesign option';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column form_type in quotation_request_form_values table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quotation_request_form_values'
        AND table_schema = DATABASE()
        AND column_name IN('form_type')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quotation_request_form_values ADD form_type VARCHAR(255) NULL"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;




-- Add new column is_default in  quote_dynamic_form_values table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'quote_dynamic_form_values'
        AND table_schema = DATABASE()
        AND column_name IN('is_default')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE quote_dynamic_form_values ADD is_default TINYINT(1) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add default value to quote_dynamic_form_values table

INSERT INTO quote_dynamic_form_values (label, label_slug, attribute_id, placeholder, is_required, store_id, is_default)
SELECT 'Customer name', 'customername', '1', 'Customer name', '1', '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, label_slug FROM quote_dynamic_form_values 
where store_id='1' and label_slug='customername');

-- Add default value to quote_dynamic_form_values table

INSERT INTO quote_dynamic_form_values (label, label_slug, attribute_id, placeholder, is_required, store_id, is_default)
SELECT 'Customer email', 'customeremail', '2', 'Customer email', '1', '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, label_slug FROM quote_dynamic_form_values 
where store_id='1' and label_slug='customeremail');
-- Add new column is_default in user_roles table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'user_roles'
        AND table_schema = DATABASE()
        AND column_name IN('is_default')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE user_roles ADD is_default TINYINT(1) NULL DEFAULT '0' COMMENT '0-not default, 1-default';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new row in user_roles table

INSERT INTO `user_roles` (`store_id`, `role_name`, `is_default`)
SELECT '1' ,'Operator', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, role_name FROM user_roles 
where store_id='1' and role_name='Operator');


UPDATE `user_roles` SET `is_default` = 1 WHERE `xe_id` = 1;


-- Add new row in user_privileges table
INSERT INTO `user_privileges` (`xe_id`, `module_name`, `store_id`, `status`)
SELECT '7', 'Customers' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, store_id, module_name FROM user_privileges 
where xe_id=7 and store_id='1' and module_name='Customers');


INSERT INTO `user_privileges` (`xe_id`, `module_name`, `store_id`, `status`)
SELECT '8', 'Quotation' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, store_id, module_name FROM user_privileges 
where xe_id=8 and store_id='1' and module_name='Quotation');

INSERT INTO `user_privileges` (`xe_id`, `module_name`, `store_id`, `status`)
SELECT '9', 'Vendor and Purchase order' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, store_id, module_name FROM user_privileges 
where xe_id=9 and store_id='1' and module_name='Vendor and Purchase order');


INSERT INTO `user_privileges` (`xe_id`, `module_name`, `store_id`, `status`)
SELECT '10', 'Orders' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, store_id, module_name FROM user_privileges 
where xe_id=10 and store_id='1' and module_name='Orders');

INSERT INTO `user_privileges` (`xe_id`, `module_name`, `store_id`, `status`)
SELECT '11', 'Production' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT xe_id, store_id, module_name FROM user_privileges 
where xe_id=11 and store_id='1' and module_name='Production');


UPDATE `user_privileges` SET `status` = '0' WHERE `module_name` = 'Production Hub';

-- Table structure for table `privileges_sub_modules` 

CREATE TABLE IF NOT EXISTS `privileges_sub_modules`(
    `xe_id` int(11) NOT NULL AUTO_INCREMENT,
    `user_privilege_id` int(10) NOT NULL,
    `type` varchar(255) NOT NULL COMMENT 'Operator, Agent',
    `slug` varchar(255) NOT NULL,
    `comments` TEXT NULL,
    `is_default` TINYINT(1) NOT NULL DEFAULT '1',
    PRIMARY KEY(`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Add new row in privileges_sub_modules table
INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '7', 'Manage customers', 'manage_customer'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='7' and type='Manage customers' and slug='manage_customer');


INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '7', 'Send promotional emails', 'send_promotional_emails'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='7' and type='Send promotional emails' and slug='send_promotional_emails');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '8', 'Manage quotation', 'manage_quotation'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='8' and type='Manage quotation' and slug='manage_quotation');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '8', 'Re-assign option', 'reassign_option'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='8' and type='Re-assign option' and slug='reassign_option');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '9', 'Manage vendors', 'manage_vendors'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='9' and type='Manage vendors' and slug='manage_vendors');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '9', 'Manage PO', 'manage_po'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='9' and type='Manage PO' and slug='manage_po');


INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '11', 'Change due date', 'change_due_date'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='11' and type='Change due date' and slug='change_due_date');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '11', 'Mark as done', 'mark_as_done'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='11' and type='Mark as done' and slug='mark_as_done');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '1', 'Import catalog', 'import_catalog'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='1' and type='Import catalog' and slug='import_catalog');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '1', 'Create decorated product', 'create_decorated_product'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='1' and type='Create decorated product' and slug='create_decorated_product');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '1', 'Decoration Settings', 'product_decoration_settings'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='1' and type='Decoration Settings' and slug='product_decoration_settings');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '2', 'Clipart', 'clipart'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='2' and type='Clipart' and slug='clipart');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '2', 'Backgrounds', 'background'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='2' and type='Backgrounds' and slug='background');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '2', 'Shapes', 'shapes'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='2' and type='Shapes' and slug='shapes');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '2', 'Printable colors', 'colors'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='2' and type='Printable colors' and slug='colors');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '2', 'Fonts', 'fonts'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='2' and type='Fonts' and slug='fonts');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '2', 'Graphic font', 'graphic-font'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='2' and type='Graphic font' and slug='graphic-font');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '2', 'Image masks', 'image-mask'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='2' and type='Image masks' and slug='image-mask');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '2', 'Templates', 'template'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='2' and type='Templates' and slug='template');


INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'General', 'general'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='3' and type='General' and slug='general');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'Template on products', 'template-on-products'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='4' and type='Template on products' and slug='template-on-products');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'Appearance', 'appearance'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='4' and type='Appearance' and slug='appearance');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'Image', 'image'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='4' and type='Image' and slug='image');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'Store', 'store'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='4' and type='Store' and slug='store');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'Cart', 'cart'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='4' and type='Cart' and slug='cart');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'Order', 'orders'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='4' and type='Order' and slug='orders');

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '4', 'Language', 'language'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='4' and type='Language' and slug='language');


-- Add new column xe_id in user_role_privileges_rel table

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'user_role_privileges_rel'
        AND table_schema = DATABASE()
        AND column_name IN('xe_id')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE user_role_privileges_rel ADD `xe_id` INT(10) NOT NULL AUTO_INCREMENT , ADD PRIMARY KEY (`xe_id`);"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;



-- Table structure for table `privileges_sub_modules_rel` 

CREATE TABLE IF NOT EXISTS `privileges_sub_modules_rel`(
    `privilege_rel_id` int(11) NOT NULL,
    `privileges_sub_module_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- Table structure for table `user_module_privilege` 

CREATE TABLE IF NOT EXISTS `user_module_privilege_rel`(
    `xe_id` int(11) NOT NULL AUTO_INCREMENT,
    `user_id` int(11) NOT NULL,
    `role_id` int(11) NOT NULL,
    `role_type` varchar(255) NOT NULL COMMENT 'Operator, Agent',
    `privilege_id` int(10) NOT NULL,
    PRIMARY KEY(`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- Table structure for table `user_sub_module_privilege_rel` 

CREATE TABLE IF NOT EXISTS `user_sub_module_privilege_rel`(
    `xe_id` int(11) NOT NULL AUTO_INCREMENT,
    `user_module_privilege_id` int(11) NOT NULL,
    `action_id` int(11) NOT NULL,
    PRIMARY KEY(`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;






