-- Add new column product_count in orders table

SET @s = (SELECT IF(
(SELECT COUNT(*)
FROM INFORMATION_SCHEMA.COLUMNS
WHERE table_name = 'orders'
AND table_schema = DATABASE()
AND column_name IN('product_count')
) > 0,
"SELECT 1",
"ALTER TABLE orders ADD product_count INT(5) NULL DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add new row in privileges_sub_modules table

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '10', 'Show Price', 'order_show_price'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='10' and type='Show Price' and slug='order_show_price');


-- Add new row in privileges_sub_modules table

INSERT INTO `privileges_sub_modules` (`user_privilege_id`, `type`, `slug`)
SELECT '11', 'Show Price', 'production_show_price'
FROM DUAL
WHERE NOT EXISTS (SELECT user_privilege_id, type, slug FROM privileges_sub_modules 
where user_privilege_id='11' and type='Show Price' and slug='production_show_price');