/*Table structure for table barcodes*/

CREATE TABLE IF NOT EXISTS `barcodes` (
  xe_id  int(11) NOT NULL AUTO_INCREMENT,
  name varchar(100) NOT NULL,
  slug varchar(40) NOT NULL COMMENT 'It is used for performing a particular action',
  module_id tinyint(2) NOT NULL COMMENT '2-Order,4-Production' ,
  barcode_number varchar(40) NOT NULL,
  barcode_image varchar(40) NOT NULL,
  store_id int(4) NOT NULL,
  is_active tinyint(2) NOT NULL  DEFAULT '1' COMMENT '1-Active,0-In Active' ,
  created_at datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY(xe_id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Insert data into barcodes table

INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id , is_active)
SELECT  'Order details', 'order_details', '2', '202203300501306573' ,'202203300501306573.png', '1' , '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='order_details');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id , is_active)
SELECT 'Download order artwork files', 'download_order_artwork_file', '2', '202203300501303395', '202203300501303395.png' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='download_order_artwork_file');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Open order invoice', 'open_order_invoice', '2', '202203300501304483', '202203300501304483.png' , '1' , '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='open_order_invoice');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id , is_active)
SELECT 'Print order invoice', 'print_order_invoice', '2', '20220330050130825', '20220330050130825.png' , '1', '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='print_order_invoice');

INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Download order invoice', 'download_order_invoice', '2', '202203300501302123', '202203300501302123.png' , '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='download_order_invoice');

INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Open work order slip', 'open_work_order_slip', '2', '202203300501305424','202203300501305424.png' , '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='open_work_order_slip');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Print work order slip', 'print_work_order_slip', '2', '202203300501305513', '202203300501305513.png' , '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='print_work_order_slip');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Download work order slip', 'download_work_order_slip', '2', '202203300501305653', '202203300501305653.png' , '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='download_work_order_slip');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Download packing slip', 'download_packing_slip', '2', '202203300501301308', '202203300501301308.png' , '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='download_packing_slip');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image,store_id, is_active)
SELECT 'Create production job from order', 'create_production_job_from_order', '2', '202203300501303696', '202203300501303696.png' , '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='create_production_job_from_order');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'View production job', 'view_production_job', '2', '202203300501304802', '202203300501304802.png' , '1' , '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='2' and slug='view_production_job');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'View job details', 'view_job_details', '4', '202203300501301584', '202203300501301584.png' , '1' , '0'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='4' and slug='view_job_details');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image,store_id, is_active)
SELECT 'Print job details', 'print_job_details', '4', '20220330050130615', '20220330050130615.png' , '1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='4' and slug='print_job_details');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Download job details', 'download_job_details', '4', '202203300501302745', '202203300501302745.png' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='4' and slug='download_job_details');

INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Mark job status start printing as Done', 'start_printing', '4', '20220330050130191',  '20220330050130191.png' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='4' and slug='start_printing');


INSERT INTO barcodes (name, slug, module_id, barcode_number, barcode_image, store_id, is_active)
SELECT 'Mark job status start shipping as Done', 'shipping', '4', '202203300501308508', '202203300501308508.png' ,'1', '1'
FROM DUAL
WHERE NOT EXISTS (SELECT store_id, module_id, slug FROM barcodes  
WHERE store_id='1' AND module_id='4' and slug='shipping');

-- Insert barcode settings as row-1 in settings

INSERT INTO  settings (setting_key,setting_value,type,store_id)  
SELECT 'barcode_settings', '{"columns": [{"value": 1,"is_active": 1},{"value": 2,"is_active": 0}],"label_font_size": [{"value": "5px","is_active": 1}, {"value": "10px","is_active": 0}, {"value": "15px","is_active": 0}],"font_size": [{"value": "10px","is_active": 1}, {"value": "15px","is_active": 0}, {"value": "20px","is_active": 0}],"margin": [{"value": "15px","is_active": 0},{"value": "20px","is_active": 0}]}' , '0' , '1' FROM DUAL WHERE NOT EXISTS (SELECT * FROM settings WHERE setting_key='barcode_settings' AND store_id = '1');

-- Update production_status slug

UPDATE `production_status` SET `slug` = 'start_printing' WHERE `module_id` = '4' AND  `store_id` = '1' AND `status_name` = 'Start Printing';

UPDATE `production_status` SET `slug` = 'shipping' WHERE `module_id` = '4' AND  `store_id` = '1' AND `status_name` = 'Shipping';
-- Table structure for table `Product Over Logo Setting`

CREATE TABLE IF NOT EXISTS `product_overlogo_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `store_id` int(11) DEFAULT NULL,
  `is_overlogo` tinyint(1) DEFAULT 0,
    PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table `Product Over Logo Sides`

CREATE TABLE IF NOT EXISTS `product_overlogo_sides` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_setting_id` int(11) NOT NULL,
  `side_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `is_visible` tinyint(1) NOT NULL DEFAULT 1,
   PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Table structure for table `Product Over Logo Sides Decorations`

CREATE TABLE IF NOT EXISTS `product_overlogo_decoration_settings` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_setting_id` int(11) NOT NULL,
  `product_side_id` int(11) DEFAULT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `surface` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `path` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `print_size` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `logo_position` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `height` int(6) DEFAULT NULL,
  `width` int(6) DEFAULT NULL,
  `print_area_id` bigint(20) NOT NULL,
   PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE IF NOT EXISTS `overlogo_images` (
  `xe_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `browser_id` varchar(50) COLLATE utf8_unicode_ci NULL,
  `file_name` varchar(50) COLLATE utf8_unicode_ci NULL,
   PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Add 'catalog_code' column in catalog_product_rel table*/

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'catalog_product_rel'
        AND table_schema = DATABASE()
        AND column_name IN('catalog_code')
    ) > 0,
    "SELECT 1",
  "ALTER TABLE `catalog_product_rel` ADD `catalog_code` int(3) NOT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/*Create catalog_order_rel table*/

CREATE TABLE IF NOT EXISTS `catalog_order_rel` (
  `catalog_code` int(3) NOT NULL,
  `order_id` varchar(50),
  `catalog_order_id` varchar(50) DEFAULT NULL,   
  `created_date` datetime NOT NULL,   
  `report` varchar(200) DEFAULT NULL,  
  `shipping` text DEFAULT NULL,
  `status` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Create plugin_settings table*/

CREATE TABLE IF NOT EXISTS `plugin_settings` (
  `xe_id` int(3) NOT NULL AUTO_INCREMENT ,
  `catalog_code` varchar(50) NOT NULL,
  `settings` text DEFAULT NULL,
  `created_date` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_date` datetime DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`xe_id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;


/*Create Production Quickbook Relation Table */

CREATE TABLE IF NOT EXISTS `production_quickbooks_rel` (
  `module_type` varchar(50) NOT NULL COMMENT 'quotation or customer or vendor etc',
  `imp_id` varchar(50) NOT NULL COMMENT 'quotation_id or customer_id etc generated in store',
  `quickbooks_id` varchar(30) NOT NULL COMMENT 'estimate_id or customer_id or vendor_id generated in Quickbooks'
)ENGINE=InnoDB DEFAULT CHARSET=utf8;

