/* Add new column max_thread_color in  price_module_settings table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'price_module_settings'
        AND table_schema = DATABASE()
        AND column_name IN('max_thread_color')
    ) > 0,
    "SELECT 1",
    "ALTER TABLE `price_module_settings` ADD `max_thread_color` INT DEFAULT 0;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/* Add new column output_formats in  price_module_settings table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'price_module_settings'
        AND table_schema = DATABASE()
        AND column_name IN('output_formats')
    ) > 0,
    "SELECT 1",
    "ALTER TABLE `price_module_settings` ADD `output_formats` MEDIUMTEXT DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/* Add new column digitization_cost in  price_module_settings table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'price_module_settings'
        AND table_schema = DATABASE()
        AND column_name IN('digitization_cost')
    ) > 0,
    "SELECT 1",
    "ALTER TABLE `price_module_settings` ADD `digitization_cost` MEDIUMTEXT DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/* Add new column extra_cost in  price_module_settings table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'price_module_settings'
        AND table_schema = DATABASE()
        AND column_name IN('extra_cost')
    ) > 0,
    "SELECT 1",
    "ALTER TABLE `price_module_settings` ADD `extra_cost` MEDIUMTEXT DEFAULT NULL;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

/* Add new column greater_price in  price_tier_values table */

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'price_tier_values'
        AND table_schema = DATABASE()
        AND column_name IN('greater_price')
    ) > 0,
    "SELECT 1",
    "ALTER TABLE `price_tier_values` ADD `greater_price` INT DEFAULT 0;"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Data for the table `price_modules`

INSERT INTO price_modules (slug, sort_order_index)
SELECT 'embroidery-preview', '14' 
FROM DUAL WHERE NOT EXISTS (SELECT slug,sort_order_index  FROM price_modules  
WHERE slug='embroidery-preview');
/* Add 'cloud_storage' column in cliparts table*/

SET @s = (SELECT IF(
    (SELECT COUNT(*)
	    FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'cliparts'
  		AND table_schema = DATABASE()
  		AND column_name IN('cloud_storage')
  	 ) > 0,
  	"SELECT 1",
    "ALTER TABLE `cliparts` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

  /* Add 'cloud_storage' column in fonts table*/

  SET @s = (SELECT IF(
  	(SELECT COUNT(*)
  		FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'fonts'
  		AND table_schema = DATABASE()
  		AND column_name IN('cloud_storage')
  		) > 0 ,
  	"SELECT 1",
  	"ALTER TABLE `fonts` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
  	));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;


  /* Add 'cloud_storage' column in backgrounds table*/

  SET @s = (SELECT IF(
  	(SELECT COUNT(*)
  		FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'backgrounds'
  	 	AND table_schema = DATABASE()
  		AND column_name IN('cloud_storage')
  		) > 0 ,
  	"SELECT 1",
  	"ALTER TABLE `backgrounds` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
  	));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;


   /* Drop 'file_name' column from masks table*/

  SET @s = (SELECT IF(
  	(SELECT COUNT(*)
  		FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'masks'
  	 	AND table_schema = DATABASE()
  		AND column_name IN('file_name')
  		) > 0 ,
  	"SELECT 1",
  	"ALTER TABLE `masks` DROP `file_name`;"
  	));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  
  /* Add 'cloud_storage' column in masks table*/

  SET @s = (SELECT IF(
  	(SELECT COUNT(*)
  		FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'masks'
  	 	AND table_schema = DATABASE()
  		AND column_name IN('cloud_storage')
  		) > 0 ,
  	"SELECT 1",
  	"ALTER TABLE `masks` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
  	));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;


   /* Add 'cloud_storage' column in color_palettes table*/

  SET @s = (SELECT IF(
  	(SELECT COUNT(*)
  		FROM INFORMATION_SCHEMA.COLUMNS
  		WHERE table_name = 'color_palettes'
  	 	AND table_schema = DATABASE()
  		AND column_name IN('cloud_storage')
  		) > 0 ,
  	"SELECT 1",
  	"ALTER TABLE `color_palettes` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
  	));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;


   /* Add 'cloud_storage' column in shapes table*/


  SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'shapes'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `shapes` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  /* Add 'cloud_storage' column in graphic_fonts table*/
  
SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'graphic_fonts'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `graphic_fonts` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  /* Add 'cloud_storage' column in product_images table*/
  
SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'product_images'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `product_images` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  
  /* Add 'cloud_storage' column in design_states table*/
  
SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'design_states'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `design_states` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

/* Add 'cloud_storage' column in print_areas table*/
SET @s = (SELECT IF(
    (SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE table_name = 'print_areas'
    AND table_schema = DATABASE()
    AND column_name IN("cloud_storage")
    ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `print_areas` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
    PREPARE stmt FROM @s;
    EXECUTE stmt;
    DEALLOCATE PREPARE stmt;

/* Add 'cloud_storage' column in product_section_images table*/
SET @s = (SELECT IF(
    (SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE table_name = 'product_section_images'
    AND table_schema = DATABASE()
    AND column_name IN("cloud_storage")) > 0 ,
    "SELECT 1",
    "ALTER TABLE `product_section_images` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
    PREPARE stmt FROM @s;
    EXECUTE stmt;
    DEALLOCATE PREPARE stmt;

/* Add 'cloud_storage' column in color_swatches table*/
SET @s = (SELECT IF(
    (SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE table_name = 'color_swatches'
    AND table_schema = DATABASE()
    AND column_name IN("cloud_storage")) > 0 ,
    "SELECT 1",
    "ALTER TABLE `color_swatches` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
    PREPARE stmt FROM @s;
    EXECUTE stmt;
    DEALLOCATE PREPARE stmt;

/* Add 'cloud_storage' column in decoration_objects table*/
SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'decoration_objects'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `decoration_objects` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  /* Add 'cloud_storage' column in print_profiles table*/
SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'print_profiles'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `print_profiles` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

    /* Add 'cloud_storage' column in product_configurator_sides table*/
SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'product_configurator_sides'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `product_configurator_sides` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  /* Add 'cloud_storage' column in browser_images table*/
    SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'browser_images'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `browser_images` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  /* Add 'cloud_storage' column in user_upload_image table*/
    SET @s = (SELECT IF(
    (SELECT COUNT(*)
      FROM INFORMATION_SCHEMA.COLUMNS
      WHERE table_name = 'user_upload_image'
      AND table_schema = DATABASE()
      AND column_name IN('cloud_storage')
      ) > 0 ,
    "SELECT 1",
    "ALTER TABLE `user_upload_image` ADD `cloud_storage` TINYINT(1) NOT NULL DEFAULT '0';"
    ));
  PREPARE stmt FROM @s;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;