-- Add new column 'margin_type' in catalog_product_rel table

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'catalog_product_rel'
        AND table_schema = DATABASE()
        AND column_name IN('margin_type')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `catalog_product_rel` ADD `margin_type` VARCHAR(20) NULL DEFAULT NULL COMMENT 'percentage/flat'"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new column 'margin_value' in catalog_product_rel table

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'catalog_product_rel'
        AND table_schema = DATABASE()
        AND column_name IN('margin_value')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `catalog_product_rel` ADD `margin_value` DECIMAL(10,2) NULL DEFAULT '0'"
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
-- Add new column 'is_blank_canvas' in templates table

SET @s = (SELECT IF(
    (SELECT COUNT(*)  
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'templates'
        AND table_schema = DATABASE()
        AND column_name IN('is_blank_canvas')
    ) > 0,
    "SELECT 1",
	"ALTER TABLE `templates` ADD `is_blank_canvas` BOOLEAN NULL DEFAULT 0 "
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;