
-- Table structure for table `sales_channel` 

CREATE TABLE IF NOT EXISTS `sales_channel` (
  `xe_id` int(4) NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(100) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `sales_channel` (`xe_id`, `channel_name`)
SELECT '1', 'Online Store' FROM DUAL WHERE NOT EXISTS 
(SELECT * FROM sales_channel WHERE xe_id='1');

INSERT INTO `sales_channel` (`xe_id`, `channel_name`)
SELECT '2', 'Amazon' FROM DUAL WHERE NOT EXISTS 
(SELECT * FROM sales_channel WHERE xe_id='2');
-- Table structure for table `sales_channel_artwork` 

CREATE TABLE IF NOT EXISTS `sales_channel_artwork` (
  `xe_id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL,
  `sku` varchar(100) NOT NULL,
  PRIMARY KEY (`xe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Table structure for table `sales_channel_artwork_relation` 

CREATE TABLE IF NOT EXISTS `sales_channel_artwork_relation` (
  `artwork_id` int(11) NOT NULL,
  `sales_channel_id` int(4) NOT NULL,
  `product_id` varchar(100) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
-- Alter quotations table shipping_type column type

SET @s = (SELECT IF(
	(SELECT COUNT(*)
		FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'quotations'
		) > 0,
		"ALTER TABLE `quotations` CHANGE `shipping_type` `shipping_type` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL",
		"SELECT 1"
	)
);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add new row in production_hub_settings table

INSERT INTO `production_hub_settings` (`xe_id`, `store_id`, `module_id`, `setting_key`, `setting_value`, `flag`)
SELECT NULL, '1', '1', 'shipping_methods', '[{\"shipping_name\":\"Free\",\"shipping_price\":\"0\"},{\"shipping_name\":\"Regular\",\"shipping_price\":\"50\"},{\"shipping_name\":\"Express\",\"shipping_price\":\"100\"}]', '0' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_hub_settings WHERE setting_key='shipping_methods' AND module_id='1');

INSERT INTO `production_hub_settings` (`xe_id`, `store_id`, `module_id`, `setting_key`, `setting_value`, `flag`)
SELECT NULL, '1', '1', 'tax_percent', '[\"5\",\"7\"]', '0' FROM DUAL WHERE NOT EXISTS (SELECT * FROM production_hub_settings WHERE setting_key='tax_percent' AND module_id='1');