 /* ============================================================
 * JS related to step three for installation goes here.
 * This will be called in only 3rd page of the installation.
 * This will check and set Database details, store and inkXE admin credentials
 * ============================================================ */ 
 function DBsetUp(){
 	$('#message').addClass('d-none');
 	var validInput = true;
	var serviceURL = getBaseURL();
 	var langs = get(serviceURL+'getLanguageSelected');
	$("input").each(function() {
	   var element = $(this);
	   if (element.val() == "") {
	       validInput = false;
	       return
	   }
	});
	if (validInput == true) {
		var input = {};
		input['host'] = $('#host').val();
		input['dbname'] = $('#dbName').val();
		input['user'] = $('#dbUser').val();
		input['pwd'] = $('#dbPwd').val();
		var postInfo = btoa(JSON.stringify(input));
	}else {
		$('#message').removeClass('d-none');
        $('#errorMSG').text(langs.ENTER_ALL_VAL);
		return;
	}
	$("#loader").removeClass('d-none');
	var infoURL = serviceURL+'getPackageInfo'; 
 	var info = get(infoURL);
 	var storeName = info.data.store;
 	var storeVersion = info.data.store_api_ver;

	 var saveURL = serviceURL+'saveConfiguration';	
	 // check Magento store location 1 : for current server 0 : for remote server
	 var locationStatus = 1;
	 if(storeName == 'magento'){
		 locationStatus = get(serviceURL+'magentoServerLocation');
	 }

	var dataArr = {"type": 'db', "data": postInfo};
	// post to server
	var settings = {
	  "url": saveURL,
	  "method": "POST",
	  "headers": {
	    "Content-Type": "application/x-www-form-urlencoded"
	  },
	  "data": dataArr,
	  success: function (result) {
	 		var response = JSON.parse(result);
	       if (response.proceed_next) {
		       	$("#head2").addClass('active');
				if(locationStatus == 1){
					$("#inputForm").load("wizard/html/"+storeName+"_form.html");
				}else{
					$("#inputForm").load("wizard/html/"+storeName+"_form_remote.html");
				}

	       }else{
	       	$('#message').removeClass('d-none');
        	$('#errorMSG').text(langs[response.message]);
        	$("#loader").addClass('d-none');
	       }
	   	}
	};
	$.ajax(settings).done(function (response) {
		updateLanguage();
		setTimeout(function() { 
	    	$("#loader").addClass('d-none');
    	}, 2000);
	});
}

function setStoreCred(){
	$('#message').addClass('d-none');
	var validInput = true;
	var serviceURL = getBaseURL();
 	var langs = get(serviceURL+'getLanguageSelected');
	var input = {};
	var versionId = $('#api-versions').val();
	$("input").each(function() {
	   var element = $(this);
	   if (element.val() == "") {
	       validInput = false;
	       return
	   }
	   if (element.attr('type') != 'button') {
	   	 input[element.attr('name')] = element.val();
	   }
	});
	input['apiVersion'] = versionId;
	if (validInput == true) {
		var postInfo = btoa(JSON.stringify(input));
		console.log(postInfo);
	}else {
		$('#message').removeClass('d-none');
        $('#errorMSG').text(langs.ENTER_ALL_VAL);
		return;
	}
	$("#loader").removeClass('d-none');
 	var saveURL = serviceURL+'saveConfiguration';
	var dataArr = {"type": 'store', "data": postInfo};
	// post to server
	var settings = {
	  "url": saveURL,
	  "method": "POST",
	  "headers": {
	    "Content-Type": "application/x-www-form-urlencoded"
	  },
	  "data": dataArr,
	  success: function (result) {
	 		var response = JSON.parse(result);
	 		console.log(response);
	       if (response.proceed_next) {
		       	$("#head2").addClass('active');
		       	$("#head3").addClass('active');
		       	$('#inputForm').load("wizard/html/admin_form.html");
	       }else{
	       	$('#message').removeClass('d-none');
        	$('#errorMSG').text(response.message);
	       }
	   	}
	};
	$.ajax(settings).done(function (response) {
		updateLanguage();
	 	setTimeout(function() { 
	    	$("#loader").addClass('d-none');
    	}, 2000);
	});

}

function blockSpace(e){
	var k;
	document.all ? k = e.keyCode : k = e.which;
	return (k != 32);
	}

function createAdmin(){
	$('#message').addClass('d-none');
	var validInput = true;
	var serviceURL = getBaseURL();
 	var langs = get(serviceURL+'getLanguageSelected');
	var input = {};
   var questionID1 = $('#question1').val();
   var questionID2 = $('#question2').val();
	$("input").each(function() {
	   var element = $(this);
	   if (element.val() == "" || !(questionID1) || !(questionID2)) {
	       validInput = false;
	       return;
	   }
	   if (element.attr('type') != 'button') {
	   	 input[element.attr('name')] = element.val();
	   }
	   input['question_id1'] = questionID1;
	   input['question_id2'] = questionID2;
	   input['securAns1'] = unescape(encodeURIComponent(input['securAns1']));
	   input['securAns2'] = unescape(encodeURIComponent(input['securAns2']));
	   var langs = get(serviceURL+'getSelectedLanguageName');
		if(langs != 0){
		  var langName1 = langs.language;
		  var langExt = langName1.split('.').slice(0, -1).join('.');
		  var langSplit = langExt.split("_");
		  var langName = langSplit[1];
		  langName = langName.toLowerCase();
		}else{
		  var langName = 'english';
		}
		input['language_selected'] = langName;
	});
	if ($("input[name=adminUser]").val() !== "") {
		if (!isEmail($("input[name=adminUser]").val())) {
		   	$('#message').removeClass('d-none');
		    $('#errorMSG').text(langs.INVALID_USER_NAME);
	   		return;
		}
    }
   if ($("input[name=adminPassword]").val() !== $("input[name=password]").val()) {
   	$('#message').removeClass('d-none');
    $('#errorMSG').text(langs.PASSWORD_MISMATCH);
   	return;
   }
   if ($("input[name=adminPassword]").val().length < 8) {
   		$('#message').removeClass('d-none');
    	$('#errorMSG').text(langs.SHORT_PASSWORD);
    	return;
   }
	if (validInput == true) {
		var postInfo = btoa(JSON.stringify(input));
	}else {
		$('#message').removeClass('d-none');
        $('#errorMSG').text(langs.ENTER_ALL_VAL);
		return;
	}
	$("#loader").removeClass('d-none');
	var infoURL = serviceURL+'getPackageInfo'; 
 	var info = get(infoURL);
 	var storeName = info.data.store;
 	var saveURL = serviceURL+'saveConfiguration';
	var dataArr = {"type": 'admin', "data": postInfo};
	var settings = {
	  "url": saveURL,
	  "method": "POST",
	  "headers": {
	    "Content-Type": "application/x-www-form-urlencoded"
	  },
	  "data": dataArr,
	  success: function (result) {
	 		var response = JSON.parse(result);
	 		console.log(response);
	       if (response.proceed_next) {
		       	var domain = getBaseSiteURL();
            	if (storeName == 'others'){
            		$("body").load(domain+"/toolInfo.html");
			 	} else {
            		$("body").load(domain+"/toolSetup.html");
			 	}
	       }else{
	       	$('#message').removeClass('d-none');
        	$('#errorMSG').text(langs[response.message]);
	       }
	       setTimeout(function() { 
	    	$("#loader").addClass('d-none');
    	}, 2000);
	   	}
	};
	$.ajax(settings).done(function (response) {
      updateLanguage();
	});

}

function isEmail(email) {
  var regex = /^([a-zA-Z0-9_.])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
  return regex.test(email);
}

function preventDupes( select, index ) {
		var serviceURL = getBaseURL();
 		var langs = get(serviceURL+'getLanguageSelected');
	    var options = select.options,
	        len = options.length;
	    while( len-- ) {
	        options[ len ].disabled = false;
	    }
	    select.options[ index ].disabled = true;
	    if( index === select.selectedIndex ) {
	        $('#message').removeClass('d-none');
        	$('#errorMSG').text(langs.SELECT_DIFF_QUESTION);
	        this.selectedIndex = 0;
	    }
	}

	function getApiversion(){
		if ($('#api-versions').length){
		const date = new Date();
		const curr_month = date.getMonth() + 1;
		let prev_year = date.getFullYear() - 1;
		let curr_year = date.getFullYear();
		var apiversion = [];
		var yearData = [];
		var prevYearData = [];
		
		// Store all current year api version
		for(let monthValue = 1; monthValue <= 10; monthValue += 3) {
			if(monthValue < curr_month) {
				yearData.push(`${curr_year}-${monthValue.toString().padStart(2, '0')}`);
			}
		}

        if(yearData.length !== 4) {
			for(i = 10; i > yearData.length; i -= 3) {
				prevYearData.push(`${prev_year}-${i.toString().padStart(2, '0')}`);
			}
		}
		else {
			 apiversion = yearData;
		  }
		     apiversion = yearData.concat(prevYearData);
		
		var sortedVersion = apiversion.sort();
		var finalVersionLog = sortedVersion.reverse();
		if(finalVersionLog.length > 4){
			finalVersionLog.length = 4;
		}
		$('.versionlog').append($("<option></option>").attr("value",'').text('Select an API version'));
		$(finalVersionLog).each(function(key, val) {
			$('.versionlog').append($("<option></option>").attr("value",val).text(val));
		});
	  }
	  
	 }

 $(document).ready(function() {
 	// Check Server Settings
 	var serviceURL = getBaseURL();
 	var pkgURL = serviceURL+'getPackageInfo'; 
 	var pkgDetails = get(pkgURL);
 	var storeName = pkgDetails.data.store;
 	var storeVersion = pkgDetails.data.store_api_ver;
 	if(storeName == 'magento'){

		// check Magento store location 1 : for current server 0 : for remote server
		var locationStatus = 1;
		locationStatus = get(serviceURL+'magentoServerLocation'); 	
 	}
 	if (storeName == 'opencart' || storeName == 'others'){
 		$("#head2").hide();
 	}
 	var pageDetails = get(serviceURL+'checkCurrentStep');
 	// var showStep = pageDetails.show_step;
 	var stopAt = pageDetails.stop_at;
 	switch(stopAt) {
		  case 2:
		  	console.log("/wizard/html/"+storeName+"_form.html");
			if(locationStatus == 1){
				$("#inputForm").load("wizard/html/"+storeName+"_form.html");
			}else{
				$("#inputForm").load("wizard/html/"+storeName+"_form_remote.html");
			}
			
	    	$("#head2").addClass('active');
		    break;
		  case 3:
	    	$("#head2").addClass('active');
	    	$("#head3").addClass('active');
	    	$("#inputForm").load("wizard/html/admin_form.html");
		    break;
		}
	$("body").on('DOMSubtreeModified', "inputForm", function() {
	    alert('changed');
	});
 	$("#loader").addClass('d-none');
 	
	updateLanguage();
 	
 });



 function createStoreCred(){
	$('#message').addClass('d-none');
	var validInput = true;
	var serviceURL = getBaseURL();
 	var langs = get(serviceURL+'getLanguageSelected');
	var input = {};
	var versionId = $('#api-versions').val();
	$("input").each(function() {
	   var element = $(this);
	   if (element.val() == "") {
	       validInput = false;
	       return
	   }
	   if (element.attr('type') != 'button') {
	   	 input[element.attr('name')] = element.val();
	   }
	});
	input['apiVersion'] = versionId;
	if (validInput) {
		var postInfo = btoa(JSON.stringify(input));
		console.log(postInfo);
	}else {
		$('#message').removeClass('d-none');
        $('#errorMSG').text(langs.ENTER_ALL_VAL);
		return;
	}
	$("#loader").removeClass('d-none');
 	var saveURL = serviceURL+'saveConfiguration';
	var dataArr = {"type": 'store', "data": postInfo};
	// post to server
	var settings = {
	  "url": saveURL,
	  "method": "POST",
	  "headers": {
	    "Content-Type": "application/x-www-form-urlencoded"
	  },
	  "data": dataArr,
	  success: function (result) {
	 		var response = JSON.parse(result);
	 		console.log(response);
	       if (response.proceed_next) {
		       	$("#head2").addClass('active');
		       	$("#head3").addClass('active');
		       	$('#inputForm').load("wizard/html/admin_form.html");
	       }else{
	       	$('#message').removeClass('d-none');
        	$('#errorMSG').text(response.message);
	       }
	   	}
	};
	$.ajax(settings).done(function (response) {
		updateLanguage();
	 	setTimeout(function() { 
	    	$("#loader").addClass('d-none');
    	}, 2000);
	});

}


function validateStoreCred(){
	$('#message').addClass('d-none');
	var validInput = true;
	var serviceURL = getBaseURL();
 	var langs = get(serviceURL+'getLanguageSelected');
	var input = {};
	var versionId = $('#api-versions').val();
	$("input").each(function() {
	   var element = $(this);
	   if (element.val() == "") {
	       validInput = false;
	       return
	   }
	   if (element.attr('type') != 'button') {
	   	 input[element.attr('name')] = element.val();
	   }
	});
	input['apiVersion'] = versionId;
	if (validInput) {
		var postInfo = btoa(JSON.stringify(input));
		console.log(postInfo);
	}else {
		$('#message').removeClass('d-none');
        $('#errorMSG').text(langs.ENTER_ALL_VAL);
		return;
	}

	$("#loader").removeClass('d-none');
	//var infoURL = serviceURL+'getPackageInfo'; 
 	var saveURL = serviceURL+'validateConfiguration';
	var dataArr = {"type": 'store', "data": postInfo};
	// post to server
	var settings = {
	  "url": saveURL,
	  "method": "POST",
	  "headers": {
	    "Content-Type": "application/x-www-form-urlencoded"
	  },
	  "data": dataArr,
	  success: function (result) {		
	 		var response = JSON.parse(result);
	 		console.log(response);
	       if (response.proceed_next) {
		       	$("#head2").addClass('active');
		       	$("#head3").addClass('active');
		       	$('#inputForm').load("wizard/html/admin_form.html");
	       }else{
			$('#message').removeClass('d-none');
        	$('#errorMSG').html(response.message);
	       }
	   	}
	};
	$.ajax(settings).done(function (response) {
		updateLanguage();
	 	setTimeout(function() { 
	    	$("#loader").addClass('d-none');
    	}, 2000);
	});

}