 /* ============================================================
 * JS related to step four for installation goes here.
 * This will be called in only 4th page of the installation.
 * This will create dummy products and set basic admin settings.
 * ============================================================ */ 
function prepareMethodList(methods){
	$(methods).each(function(key, val) {
 		if (val.name == 'DTG') {
 			$('#printProfile').append($("<option selected></option>").attr("value",val.id).text(val.name));
 		}else
 			$('#printProfile').append($("<option></option>").attr("value",val.id).text(val.name));
	});
}

function prepareProductList(products){
	$(products).each(function(key, val) {
 		$('#products').append($("<option></option>").attr("value",val.id).text(val.name));
	});
}

function completeSetUp(){
	$("#loader").removeClass('d-none');
	var serviceURL = getBaseURL();
 	var langs = get(serviceURL+'getLanguageSelected');
	var printMethodIDs = $('#printProfile').val();
	var ProductIDs = $('#products').val();
	
	// Check Server Settings
	var pkgURL = serviceURL+'getPackageInfo'; 
	var pkgDetails = get(pkgURL);
	//var storeName = pkgDetails.data.store;
	//var storeVersion = pkgDetails.data.store_api_ver;
	if (!printMethodIDs || !ProductIDs) {
		$('#message').removeClass('d-none');
    	$('#errorMSG').text(langs.SELECT_DUMMY_DATA);
    	$("#loader").addClass('d-none');
		return;
	}
	var themeID = '';
	$('.themeVal').each(function(count, element) {
	    if ($(this).prop("checked") == true) {
	    	themeID = $(this).val();
	    }
	});
	var themeCol = $('#themeCol').val();
	var postInfo = btoa(JSON.stringify({"print_methods": printMethodIDs, "products": ProductIDs, "themeID": themeID, "themeCol":themeCol, "setup_type": "custom"}));
 	var saveURL = serviceURL+'completeXESetup';
	var strResponse = get(serviceURL+'getStoreResponseServer');
	var dataArr = {"data": postInfo};

    $.ajax({
		type:"GET",
		cache:false,
		url:strResponse,
		dataType:"JSON",
		data:{},
		error:function (xhr, ajaxOptions, thrownError){
			var strRes = String(get(serviceURL+'getServerName'));
			if(xhr.status == 404 || xhr.status == 500 || xhr.status == 403) {
				$('#message').removeClass('d-none');
				$("#loader").addClass('d-none');
				$(".tick-icon").addClass("close_error");
				$(".tick-icon").addClass("error");
				$(".tick-icon").removeClass('tick-icon');
				$('.btn-success').hide();
				if(strRes.indexOf("nginx") >= 0  ){
					$('#errorMSG').html("Some settings need to be changed! Please check <a href='https://imprintnext.freshdesk.com/support/solutions/articles/81000387809-imprintnext-api-for-nginx-server' target='_blank'>help DOC</a>  <div class='btn btn-sm btn-dark float-right' id='retryBtn'><i class='pg pg-refresh'></i> Retry</div>");
					$("#errorMSG").delegate( "div", "click", function() {
						completeSetUp();
					});
				}else{
					$('#errorMSG').html("Due to some server error unable to create Pre-Decoration Product , Please contact to support.");
					$("#errorMSG").delegate( "div", "click", function() {
						completeSetUp();
					});
				}
				window.stop();
			}
		}
	});
	var settings = {
	  "url": saveURL,
	  "method": "POST",
	  "headers": {
	    "Content-Type": "application/x-www-form-urlencoded"
	  },
	  "data": dataArr,
	  success: function (result) {
	 		var response = JSON.parse(result);
	 		console.log(response);
	       if (response.proceed_next) {
	       		var domain = getBaseSiteURL();
            	$("body").load(domain+"/toolInfo.html");
	       }else{
	       	$('#message').removeClass('d-none');
			$('#errorMSG').html(langs[response.message]+" <a href='https://imprintnext.freshdesk.com/support/login' target ='_blank'>Click Here</a>");
	       }
	       $("#loader").addClass('d-none');
	   	}
	};
	$.ajax(settings).done(function (response) {
	});
}

$(document).ready(function() {
 	// Check Server Settings
 	var serviceURL = getBaseURL();
 	updateLanguage();
 	var methods = get(serviceURL+'getPrintMethods');
 	prepareMethodList(methods.data);
 	var products = get(serviceURL+'getDummyProducts');
 	prepareProductList(products.data);
 });